package com.yeejoin.amos.boot.module.tdc.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.module.tdc.api.entity.CheckModel;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author xxz
 */
@Service
public interface CheckModelService extends IService<CheckModel> {

    /**
     * 根据机构编码查询模型list
     * @param amosOrgCode 机构编码
     * @return 模型list
     */
//    List<CheckModel> selectByOrgCode(String amosOrgCode);
    IPage<CheckModel> selectByOrgCode(int current, int size, String amosOrgCode);

    List<CheckModel> selectByOrgCode(String amosOrgCode);

    /**
     * 查询最后一次校验模型
     * @return 模型obj
     */
    CheckModel selectOneByDate(String amosOrgCode);

    /**
     * 校验机构下全部模型
     * @param amosOrgCode 机构code
     */
    void checkAllMode(String amosOrgCode);

    /**
     * 校验单个模型
     * @param modelId 模型id
     */
    void checkSingleMode(String modelId);

    /**
     * 根据机构code和模型名称查询模型对象
     * @param modelName 模型名称
     * @param amosOrgCode 机构code
     * @return 模型对象
     */
    CheckModel selectCheckModelByNameCode(String modelName, String amosOrgCode);
}
