package com.yeejoin.amos.boot.module.jg.api.dto;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Data
@ApiModel(value = "变化的数据")
public class ChangeDataDto implements Serializable {

    /**
     * 必须字段-字段key
     */
    private String columnKey;

    /**
     * 必须字段-字段描述
     */
    private String columnLabel;

    /**
     * 必须字段-字段原始值
     */
    private String columnOldValue;

    /**
     * 必须字段-字段新值
     */
    private String columnNewValue;

    /**
     * 非必须字段-变化的数据id(设备的record、或者业务的id),持使用登记的设备信息变更、不同业务流程的业务数据变更
     */
    private String changeId;

    /**
     * 非必须字段-业务数据分类：如使用登记、安装告知等
     */
    private String bizType;

    /**
     * 非必须字段-变更数据的分类：如使用信息、制造信息、设计信息、技术参数 - key
     */
    private String columnFamily;

    /**
     * 非必须字段-字段类型-扩展使用
     */
    private String columnType;

}
