package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.annotation.FieldMapping;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.api.dto.RequestChangeData;
import com.yeejoin.amos.boot.module.jg.biz.edit.BizDataChangeServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.strategy.IBizDataChangeHandleStrategy;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.CommonServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.SingleManageEquipEditHandleImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

@RestController
@RequestMapping(value = "/data-change")
@Api(tags = "业务数据变化处理控制器")
@RequiredArgsConstructor
public class BizDataChangeController extends BaseController {

    public enum DetailType {
        equip, project
    }


    private final BizDataChangeServiceImpl bizDataChangeService;

    private final SingleManageEquipEditHandleImpl singleManageEquipEditHandle;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/v1/singleManageEquipEdit/save")
    @ApiOperation(value = "业务数据变更保存--西安专用", httpMethod = "POST")
    public ResponseModel<String> save(@RequestParam String applyNo, @RequestBody RequestChangeData changeData) {
        singleManageEquipEditHandle.doSave(applyNo, changeData, getSelectedOrgInfo());
        return ResponseHelper.buildResponse("success");
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/v1/singleManageEquipEdit/detail")
    @ApiOperation(value = "查询可业务变更的字段及默认值--西安专用", httpMethod = "GET")
    public ResponseModel<Map<String, ?>> getDetailV1(@RequestParam(required = false) String applyNo, @RequestParam(required = false) String bizId) {
        return ResponseHelper.buildResponse(singleManageEquipEditHandle.getDetail(applyNo, bizId));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/v2/{bizType}/detail")
    @ApiOperation(value = "编辑一级页面详情查询--通用", httpMethod = "GET")
    public ResponseModel<IPage<?>> getDetailV2(@ApiParam(value = "单据编号或者设备装置唯一标识") @RequestParam String applyNo,
                                               @ApiParam(value = "业务类型") @PathVariable String bizType,
                                               @ApiParam(value = "详情类型：设备、装置列表") @RequestParam DetailType type,
                                               @ApiParam(value = "查询参数") @RequestParam Map<String, Object> searchParams) {
        return ResponseHelper.buildResponse(bizDataChangeService.queryDetail(applyNo, bizType, type, new JSONObject(searchParams)));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/v2/{bizType}/sub-detail")
    @ApiOperation(value = "编辑二级页面详情查询--通用", httpMethod = "GET")
    public ResponseModel<Map<String, Object>> getSubDetailV2(@ApiParam(value = "设备或者装置唯一标识") @RequestParam String bizId,
                                                             @ApiParam(value = "单据编号,装置时需要") @RequestParam(required = false) String applyNo,
                                                             @ApiParam(value = "详情类型：设备、装置") @RequestParam DetailType type,
                                                             @ApiParam(value = "业务类型") @PathVariable String bizType) {
        return ResponseHelper.buildResponse(bizDataChangeService.querySubDetail(applyNo, bizId, bizType, type, getSelectedOrgInfo()));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/v2/{bizType}/save")
    @ApiOperation(value = "编辑保存--通用", httpMethod = "POST")
    @FieldMapping({
            @FieldMapping.FieldMap(
                    sourceField = "ESTATE_UNIT_CREDIT_CODE",
                    paramIndex = 4,
                    targetField = "ESTATE_UNIT_CREDIT_CODE",
                    serviceClass = CommonServiceImpl.class,
                    queryMethod = "queryTcmUnitCreditCodeBySeq",
                    secondParamValue = "CQ"
            )
    })
    public ResponseModel<String> saveV2(@ApiParam(value = "设备或者装置唯一标识") @RequestParam String bizId,
                                        @ApiParam(required = true, value = "单据编号或者record") @RequestParam String applyNo,
                                        @ApiParam(required = true, value = "业务类型") @PathVariable String bizType,
                                        @ApiParam(required = true, value = "设备处理器类型") @RequestParam IBizDataChangeHandleStrategy.ModelType modelType,
                                        @RequestBody RequestChangeData changeData) {

        ReginParams reginParams = getSelectedOrgInfo();
        // 基础数据校验
        changeData.validated(reginParams);
        bizDataChangeService.save(bizId, applyNo, bizType, modelType, changeData, reginParams);
        return ResponseHelper.buildResponse("success");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/v2/{bizType}/change-logs")
    @ApiOperation(value = "编辑一级页面详情查询--通用", httpMethod = "GET")
    public ResponseModel<IPage<?>> getChangeLogPage(@ApiParam(value = "设备或者装置唯一标识") @RequestParam(value = "bizId", required = false) String bizId,
                                                    @ApiParam(required = true, value = "业务类型") @PathVariable String bizType,
                                                    @RequestParam(value = "current") int current,
                                                    @RequestParam(value = "size") int size) {
        return ResponseHelper.buildResponse(bizDataChangeService.getChangeLogPage(bizId, bizType, current, size));
    }

}
