package com.yeejoin.amos.boot.module.statistcs.biz.constant;

import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import com.yeejoin.amos.boot.module.statistcs.biz.service.IZBGLService;
import com.yeejoin.amos.boot.module.statistcs.factory.ZBGLFactory;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.List;
import java.util.Map;
@Service
public class ZBGLConstants {
    public static Map<String, Object> getChart(DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        if (StringUtils.isEmpty(dpFilterParamForDetailDto.getTreeValue())){
            throw new BadRequest("类型不能为空");
        }
        IZBGLService izbglService = ZBGLFactory.getZBGL(dpFilterParamForDetailDto.getTreeValue());
        if(izbglService == null){
            throw new RuntimeException("未找到实现类");
        }
        return izbglService.getChart(dpFilterParamForDetailDto);
    }

    public static List<Map<String, String>> getTitle(DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        if (StringUtils.isEmpty(dpFilterParamForDetailDto.getTreeValue())){
            throw new BadRequest("类型不能为空");
        }
        IZBGLService izbglService = ZBGLFactory.getZBGL(dpFilterParamForDetailDto.getTreeValue());
        if(izbglService == null){
            throw new RuntimeException("未找到实现类");
        }
        return izbglService.getTitle(dpFilterParamForDetailDto);
    }

    public static Page<Map<String, Object>> getPage(Page page,DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        if (StringUtils.isEmpty(dpFilterParamForDetailDto.getTreeValue())){
            throw new BadRequest("类型不能为空");
        }
        IZBGLService izbglService = ZBGLFactory.getZBGL(dpFilterParamForDetailDto.getTreeValue());
        if(izbglService == null){
            throw new RuntimeException("未找到实现类");
        }
        return izbglService.getPage(page,dpFilterParamForDetailDto);
    }
}
