package com.yeejoin.amos.boot.module.common.api.enums;

/**
 * 反馈建议-问题类型枚举值
 */
public enum ProblemTypeEnum {

    MAJOR_ACCIDENT_HAZARDS(101, "重大事故隐患问题"),
    TWO_REGULATIONS_ISSUES(102, "两个规定问题"),
    DUAL_PREVENTION_ISSUES(103, "双重预防问题"),
    TWO_LISTS_ISSUES(104, "两个清单问题"),
    TWO_GUIDELINES_ISSUES(105, "两个指南问题"),
    BUSINESS_PROCESSING_ISSUES(106, "业务办理问题"),
    ADMINISTRATIVE_GUIDANCE(107, "行政指导"),
    TECHNICAL_SERVICES(108, "技术服务"),
    OTHER_ISSUES(109, "其他问题"),
    SUGGESTIONS(110, "建议");

    private final int id;
    private final String description;


    ProblemTypeEnum(int id, String description) {
        this.id = id;
        this.description = description;
    }

    public int getId() {
        return id;
    }

    public String getDescription() {
        return description;
    }

    @Override
    public String toString() {
        return id + ": " + name() + " -> " + description;
    }

    /**
     * 根据ID获取对应的枚举值
     */
    public static ProblemTypeEnum getById(int id) {
        for (ProblemTypeEnum category : ProblemTypeEnum.values()) {
            if (category.getId() == id) {
                return category;
            }
        }
        throw new IllegalArgumentException("No ProblemTypeEnum found with ID: " + id);
    }
}
