package com.yeejoin.amos.boot.module.cylinder.biz.listener;

import com.yeejoin.amos.boot.module.cylinder.api.dto.CylinderFillingRecordStatisticsUnitDayDto;
import com.yeejoin.amos.boot.module.cylinder.biz.event.CylinderStatisticsUnitDayInsertOrUpdateEvent;
import com.yeejoin.amos.boot.module.cylinder.biz.event.publisher.EventPublisher;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderFillingRecordDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.enums.CyclinderStatus;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author Administrator
 */
@Component
public class CylinderFillingInsertListenerForStatistics implements ICylinderFillingInsertListener {


    private EventPublisher eventPublisher;

    public CylinderFillingInsertListenerForStatistics(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void handle(CylinderFillingRecordDto cylinderFillingRecordDto) {
        CylinderFillingRecordStatisticsUnitDayDto statisticsUnitDay = new CylinderFillingRecordStatisticsUnitDayDto();
        statisticsUnitDay.setAppId(cylinderFillingRecordDto.getAppId());
        statisticsUnitDay.setRegionCode(cylinderFillingRecordDto.getRegionCode());
        statisticsUnitDay.setFillingDate(cylinderFillingRecordDto.getSyncDate());
        statisticsUnitDay.setFillingAfterSum(StringUtils.isEmpty(cylinderFillingRecordDto.getFillingEndtime()) ? 0 : 1);
        statisticsUnitDay.setFillingBeforeSum(StringUtils.isEmpty(cylinderFillingRecordDto.getFillingStarttime()) ? 0 : 1);
        statisticsUnitDay.setFillingQuantity(new BigDecimal(cylinderFillingRecordDto.getFillingQuantity()));
        statisticsUnitDay.setFillingNotPassedCount(this.justIsOk(cylinderFillingRecordDto));
        statisticsUnitDay.setFillingDate(new Date());
        statisticsUnitDay.setRecDate(new Date());
        statisticsUnitDay.setTotalSum(1);
        eventPublisher.publish(new CylinderStatisticsUnitDayInsertOrUpdateEvent(this, statisticsUnitDay));
    }

    private int justIsOk(CylinderFillingRecordDto cylinderFillingRecordDto) {
        if (CyclinderStatus.HEGE.getName().equals(cylinderFillingRecordDto.getFillingResult()) && CyclinderStatus.HEGE.getName().equals(cylinderFillingRecordDto.getCheckResult())) {
            return 0;
        } else {
            return 1;
        }
    }
}
