package com.yeejoin.amos.boot.module.jyjc.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcInspectionResultParamServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionResultParamModel;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 
 *
 * @author system_generator
 * @date 2023-12-14
 */
@RestController
@Api(tags = "报检结果参数Api")
@RequestMapping(value = "/jyjc-inspection-result-param")
public class JyjcInspectionResultParamController extends BaseController {

    @Autowired
    JyjcInspectionResultParamServiceImpl jyjcInspectionResultParamServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<JyjcInspectionResultParamModel> save(@RequestBody JyjcInspectionResultParamModel model) {
	    model = jyjcInspectionResultParamServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<JyjcInspectionResultParamModel> updateBySequenceNbrJyjcInspectionResultParam(@RequestBody JyjcInspectionResultParamModel model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(jyjcInspectionResultParamServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(jyjcInspectionResultParamServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<JyjcInspectionResultParamModel> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(jyjcInspectionResultParamServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<JyjcInspectionResultParamModel>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<JyjcInspectionResultParamModel> page = new Page<JyjcInspectionResultParamModel>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(jyjcInspectionResultParamServiceImpl.queryForJyjcInspectionResultParamPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<JyjcInspectionResultParamModel>> selectForList() {
	    return ResponseHelper.buildResponse(jyjcInspectionResultParamServiceImpl.queryForJyjcInspectionResultParamList());
	}


	/**
	 * 获取某一类设备的技术参数
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "获取某一类设备的技术参数",   notes = "获取某一类设备的技术参数")
	@GetMapping(value = "/getParamByEquipTypeCode")
	public ResponseModel<List<Map<String,Object>>> getParamByEquipTypeCode(@RequestParam String equipTypeCode) {
		return ResponseHelper.buildResponse(jyjcInspectionResultParamServiceImpl.getParamByEquipTypeCode(equipTypeCode));
	}
}
