package com.yeejoin.amos.boot.module.tcm.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.tcm.api.dto.BaseUnitLicenceDto;
import com.yeejoin.amos.boot.module.tcm.biz.service.impl.BaseUnitLicenceServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 单位注册许可信息表
 *
 * @author system_generator
 * @date 2022-08-09
 */
@RestController
@Api(tags = "单位注册许可信息表Api")
@RequestMapping(value = "/base-unit-licence")
public class BaseUnitLicenceController extends BaseController {

    @Autowired
    BaseUnitLicenceServiceImpl baseUnitLicenceServiceImpl;

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "单位注册许可信息表列表全部数据查询", notes = "单位注册许可信息表列表全部数据查询")
    @GetMapping(value = "/{unitCode}/list")
    public ResponseModel<List<BaseUnitLicenceDto>> selectForList(@PathVariable String unitCode) {
        return ResponseHelper.buildResponse(baseUnitLicenceServiceImpl.queryForBaseUnitLicenceList(unitCode));
    }
}
