package com.yeejoin.amos.patrol.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum CheckStatusEnum {
	QUALIFIED("合格","1",""),
	UNQUALIFIED("不合格","2","#DF7400"),
	OMISSION("漏检", "3","#FF0000");
	
	/**
	 * 名称，描述
	 */
	private String name;
	/**
	 * 编码
	 */
	private String code;
	
	/**
	 * 颜色
	 */
	private String color;


	private CheckStatusEnum(String name, String code,String color){
		this.name = name;
		this.code = code;
		this.color = color;
	}
	
	public static CheckStatusEnum getEnum(String code) {
		CheckStatusEnum checkStatusEnum = null;
		for(CheckStatusEnum type: CheckStatusEnum.values()) {
			if (type.getCode().equals(code)) {
				checkStatusEnum = type;
				break;
			}
		}
		
		return checkStatusEnum;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> nameList = new ArrayList<>();
		for (CheckStatusEnum c: CheckStatusEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("name", c.getName());
			map.put("code", c.getCode());
			map.put("color", c.getColor());
			nameList.add(map);
		}
		return nameList;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	

	public String getColor() {
		return color;
	}

	public void setColor(String color) {
		this.color = color;
	}

}
