package com.yeejoin.amos.patrol.dao.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.data.annotation.CreatedDate;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;


/**
 * The persistent class for the p_check_shot database table.
 *
 */
@Entity
@Table(name="p_check_shot_history")
public class CheckShotHistory implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 巡检记录id
     */
    @Column(name="check_id")
    private long checkId;

    /**
     * 权限系统org code
     */
    @Column(name="org_code")
    private String orgCode;

    /**
     * 照片内容
     */
    @Lob
    @Column(name="photo_data")
    private String photoData;

    /**
     * 拍照点名称
     */
    @Column(name="point_name")
    private String pointName;

    /**
     * 拍照类型:定点（检查项拍照），普通（检
     *
     *
     *
     *
     * 点现场照片）
     */
    @Column(name="shot_type")
    private String shotType;

    /**
     * 检查项id
     */
    @Column(name="check_input_id")
    private long checkInputId;

    /**
     * 扩展分类id
     */
    @Column(name="classify_id")
    private long classifyId;

    public long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(long classifyId) {
        this.classifyId = classifyId;
    }


    public long getCheckInputId() {
        return checkInputId;
    }

    public void setCheckInputId(long checkInputId) {
        this.checkInputId = checkInputId;
    }

    public CheckShotHistory() {
    }


    public long getCheckId() {
        return this.checkId;
    }

    public void setCheckId(long checkId) {
        this.checkId = checkId;
    }

    public String getOrgCode() {
        return this.orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getPhotoData() {
        return this.photoData;
    }

    public void setPhotoData(String photoData) {
        this.photoData = photoData;
    }

    public String getPointName() {
        return this.pointName;
    }

    public void setPointName(String pointName) {
        this.pointName = pointName;
    }

    public String getShotType() {
        return this.shotType;
    }

    public void setShotType(String shotType) {
        this.shotType = shotType;
    }

    /**
     * id
     */
    private long id;

    @CreatedDate
    @Column(name="create_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;

    @Id
    @Column(name = "ID",nullable=false,unique=true)
    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }


}