<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output encoding="utf-8"/>
<xsl:template match="/">
<html>
 <head> 
  <title>
  	智能巡检系统
  </title> 
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1,minimum-scale=1,maximum-scale=1,user-scalable=no" />
 
 <style> 
	tr {
	    height: 40px;
	}
</style>
 </head> 
 <body style="text-align: center;">
    <table border="1" width="50%" style="border-collapse:separate; border-spacing:0px 0px;margin: auto;">
    	<caption><h1>巡检记录单</h1></caption>
      <tr>
        <th  style='text-align:right'><font face="Simsun" size="2">巡检人员：</font></th>
        <th  style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="CheckInfo/check/userName"/></font></th>
        <th  style='text-align:right'><font face="Simsun" size="2">所属部门：</font></th>
        <th  style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="CheckInfo/check/department"/></font></th>
      </tr>
      <tr>
        <th  style='text-align:right'><font face="Simsun" size="2">巡检时间：</font></th>
        <th  style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="CheckInfo/check/checkDate"/> <xsl:text> </xsl:text><xsl:value-of select="CheckInfo/check/checkTime"/></font></th>
        <th  style='text-align:right'><font face="Simsun" size="2">巡检路线：</font></th>
        <th  style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="CheckInfo/check/routeName"/></font></th>
      </tr>
      <tr>
        <th  style='text-align:right'><font face="Simsun" size="2">点 编 号：</font></th>
        <th  style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="CheckInfo/check/pointNo"/></font></th>
        <th  style='text-align:right'><font face="Simsun" size="2">点 名 称：</font></th>
        <th  style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="CheckInfo/check/pointName"/></font></th>
      </tr>
      <tr>
        <th  style='text-align:right'><font face="Simsun" size="2">点 类 型：</font></th>
        <th  style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="CheckInfo/check/isFixed"/></font></th>
        <th  style='text-align:right'><font face="Simsun" size="2">巡检模式：</font></th>
        <th  style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="CheckInfo/check/checkMode"/></font></th>
      </tr>
      <tr>
        <th  style='text-align:right'><font face="Simsun" size="2">分类目录：</font></th>
        <th  style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="CheckInfo/check/title"/></font></th>
        <th  style='text-align:right'><font face="Simsun" size="2">完成状态：</font></th>
        <th  style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="CheckInfo/check/finishStatus"/></font></th>
      </tr>
      <tr>
        <th  style='text-align:right'><font face="Simsun" size="2">计划名称：</font></th>
        <th  style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="CheckInfo/check/planName"/></font></th>
        <th  style='text-align:right'><font face="Simsun" size="2">任务编号：</font></th>
        <th  style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="CheckInfo/check/planId"/></font></th>
      </tr>
       <tr>
        <th  style='text-align:right'><font face="Simsun" size="2">状态：</font></th>
        <th  style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="CheckInfo/check/isOk"/></font></th>
        <th  style='text-align:right'><font face="Simsun" size="2">检查评分：</font></th>
        <th  style='text-align:left'><font face="Simsun" size="2"><xsl:value-of select="CheckInfo/check/score"/></font></th>
      </tr>
       <tr>
        <th  style='text-align:right'><font face="Simsun" size="2">检查项目：</font></th>
        <th colspan="3" style='text-align:left;padding: 0px;border-width: 0px;'>
           <xsl:if test="count(CheckInfo/inputItems) > 0">
			<table  border="1" width="100%" style="border-collapse:separate; border-spacing:0px 0px;margin: auto;" >
				<tr>
					<th>项目名称</th>
					<th>检查结果</th>
					<th>是否合格</th>
					<th>评分</th>
				</tr>
				<xsl:for-each select="CheckInfo/inputItems">
					<tr>
						<th><xsl:value-of select="inputItem"/></th>
						<th><xsl:value-of select="input_value"/></th>
						<th><xsl:value-of select="is_ok"/></th>
						<th><xsl:value-of select="score"/></th>
					</tr>
				</xsl:for-each>
			</table>
			</xsl:if>
		</th>       
      </tr>
       <tr>
        <th  style='text-align:right'><font face="Simsun" size="2">现场照片：</font></th>
        <th colspan="3" style='text-align:left'>
        	<xsl:for-each select="CheckInfo/imgs">
	        	<img  style="width:100px; height: 135px; cursor: pointer;">
		        	<xsl:attribute name="src">
				    	<xsl:value-of select="photoData" />
				  	</xsl:attribute>
					<xsl:attribute name="onclick">
				    	<xsl:value-of select="openOperUrl" />
				  	</xsl:attribute>
			  	</img>
		  	</xsl:for-each>
        </th>
      </tr>
      <tr>
        <th  style='text-align:right'><font face="Simsun" size="2">备注说明：</font></th>
        <th colspan="3" style='text-align:left'>
        	<xsl:value-of select="CheckInfo/check/remark"/>
        </th>
      </tr>                                       
    </table>
	  </body>
</html>
</xsl:template>
</xsl:stylesheet>