package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value = "CheckObjectDto", description = "机构重点部位")
public class CheckObjectDto extends BaseDto implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "机构名称")
    private String bizOrgName;

    @ApiModelProperty(value = "机构编码")
    private String bizOrgCode;

    @ApiModelProperty(value = "重点部位数量")
    private int num;

    @ApiModelProperty(value = "归属机构")
    private String parentId;

    @ApiModelProperty(value = "单位性质")
    private String companyNature;
    
    @ApiModelProperty(value = "管理类别")
    private String managementType;

    @ApiModelProperty(value = "机构类型（部门：DEPARTMENT，单位：COMPANY，人员：PERSON）")
    private String bizOrgType;
}
