package com.yeejoin.amos.boot.module.cylinder.flc.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 地市气瓶信息汇总
 *
 * @author LiuLin
 * @date 2024-05-31
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Builder
@ApiModel(value="CityCylinderInfoDto", description="地市气瓶信息汇总")
public class CityCylinderInfoDto extends BaseDto {

   private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "地市名称")
    private String regionName;

    @ApiModelProperty(value = "地市Code")
    private String regionCode;

    @ApiModelProperty(value = "是否报警")
    @JsonProperty("isAlarm")
    private boolean isAlarm;

    @ApiModelProperty(value = "气站数量")
    private Long stationCount;

    @ApiModelProperty(value = "气瓶数量")
    private Long cylindersCount;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;
}
