package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 微信公众号用户关联
 *
 * @author duanwei
 * @date 2021-07-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_wechat_relation")
@ApiModel(value="WechatRelation对象", description="微信公众号用户关联")
public class WechatRelation extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "小程序openId")
    private String smallOpenId;

    @ApiModelProperty(value = "公众号openId")
    private String publicOpenId;

    @ApiModelProperty(value = "unionId")
    private String unionId;

    @ApiModelProperty(value = "用户id")
    private Long personId;


}
