package com.yeejoin.equipmanage.quartz;

import com.yeejoin.equipmanage.service.ICarService;
import com.yeejoin.equipmanage.service.impl.CarServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * 定时监控车辆相关指标
 * @author xxz
 */
@Component
@EnableScheduling
@Slf4j
public class CarPropertyJob {

    @Autowired
    private ICarService carService;

    /**
     * 车辆赋红码。定时查询车辆启停更新时间，
     */
    @Scheduled(cron = "${update.car.qrCode}")
    public void UpdateCarQrCode(){

        carService.updateCarStartStatus();
    }

}
