package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.yeejoin.amos.boot.module.jg.api.dto.RequestChangeData;
import com.yeejoin.amos.boot.module.jg.api.service.IBizDataChangeHandleStrategy;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.BizDataChangeServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

@RestController
@RequestMapping(value = "/data-change")
@Api(tags = "业务数据变化处理控制器")
public class BizDataChangeController {


    private final BizDataChangeServiceImpl bizDataChangeService;

    public BizDataChangeController(BizDataChangeServiceImpl bizDataChangeService) {
        this.bizDataChangeService = bizDataChangeService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/{bizType}/save")
    @ApiOperation(value = "业务数据变更保存", httpMethod = "POST")
    public ResponseModel<String> save(@RequestParam String applyNo,
                                      @PathVariable String bizType,
                                      @RequestBody RequestChangeData changeData) {
        bizDataChangeService.save(applyNo, bizType, changeData);
        return ResponseHelper.buildResponse("success");
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{bizType}/detail")
    @ApiOperation(value = "查询可业务变更的字段及默认值", httpMethod = "GET")
    public ResponseModel<Map<String, ?>> getDetail(@RequestParam(required = false) String applyNo,
                                                   @PathVariable String bizType,
                                                   IBizDataChangeHandleStrategy.ModelType model,
                                                   @RequestParam(required = false) String bizId) {
        return ResponseHelper.buildResponse(bizDataChangeService.queryDetail(applyNo, bizType, model, bizId));
    }
}
