package com.yeejoin.amos.boot.module.jczs.api.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;

/**
 * @author tb
 * @date 2021-06-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tcb_rescue_station")
@ApiModel(value = "RescueStation对象", description = "RescueStation对象")
public class RescueStation extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "名称不能为空")
    @ApiModelProperty(value = "应急救援机构名称")
    private String name;

    @ApiModelProperty(value = "省份")
    private String province;

    @NotNull(message = "地市不能为空")
    @ApiModelProperty(value = "地市")
    private String city;

    @NotNull(message = "区县不能为空")
    @ApiModelProperty(value = "区县")
    private String district;

    @NotNull(message = "区域代码不能为空")
    @ApiModelProperty(value = "区域代码")
    private String regionCode;

    @NotNull(message = "地址不能为空")
    @ApiModelProperty(value = "地址(详细地址，包括道路、门牌号码)")
    private String address;

    @ApiModelProperty(value = "责任人id")
    private Long principalId;

    @ApiModelProperty(value = "主要负责人")
    private String principal;

    @ApiModelProperty(value = "负责人电话")
    private String principalPhone;

    @ApiModelProperty(value = "应急救援负责人")
    private String rescueLeader;

    @ApiModelProperty(value = "应急救援负责人手机号")
    private String rescueLeaderPhone;

    @ApiModelProperty(value = "应急救援负责人id")
    private Long rescueLeaderId;

    @ApiModelProperty(value = "所属单位（维保单位）")
    private String affiliatedUnit;

    @ApiModelProperty(value = "所属单位id")
    private Long affiliatedUnitId;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;

}
