package com.yeejoin.amos.supervision.common.enums;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author DELL
 */

public enum CheckTypeSuEnum {
    /**
     * 检查类型枚举
     */
    DAILY("日常检查", "1", "daily"),
    SPECIAL_RQ("燃气专项", "2", "special"),
    SPECIAL_GW("高温专项", "3", "special");

    /**
     * 名字
     */
    private String name;
    /**
     * 编号
     */
    private String code;

    /**
     * 执行控制条件
     */
    private String condition;

    CheckTypeSuEnum(String name, String code, String condition) {
        this.name = name;
        this.code = code;
        this.condition = condition;
    }

    public static List<Map<String, Object>> getEnumList() {
        return Arrays.stream(CheckTypeSuEnum.values()).map(e -> {
            Map<String, Object> map = new HashMap<>();
            map.put("code", e.getCode());
            map.put("name", e.getName());
            return map;
        }).collect(Collectors.toList());
    }

    /**
     * 获取枚举
     * @param code 编号
     * @return CheckTypeSuEnum
     * @throws Exception
     */
    public static CheckTypeSuEnum getEumByCode(String code) throws Exception {
       Optional<CheckTypeSuEnum> op = Arrays.stream(CheckTypeSuEnum.values()).filter(e->e.code.equals(code)).findFirst();
       return op.orElseThrow(()->new Exception("不存在"));
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCondition() {
        return condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }
}
