package com.yeejoin.amos.video.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.video.dao.impl.VideoOriginalServiceImpl;
import com.yeejoin.amos.video.dto.VideoOriginalDto;
import com.yeejoin.amos.video.entity.VideoOriginal;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 模板表
 *
 * @author system_generator
 * @date 2021-09-01
 */
@RestController
@Api(tags = "对接视频原始数据Api")
@RequestMapping(value = "/video-original")
public class VideoOriginalController extends BaseController {

	@Autowired
	private VideoOriginalServiceImpl videoOriginalServiceImpl;

	@GetMapping("/hk/init")
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth=false)
	@ApiOperation(httpMethod = "GET", value = "构建海康原始视频数据", notes = "构建海康原始视频数据")
	public ResponseModel<Boolean> hkInitData() {
		return ResponseHelper.buildResponse(videoOriginalServiceImpl.initEs("", ""));
	}
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "按视频名称查询视频节点", notes = "按视频名称查询视频节点")
    @GetMapping(value = "/list/video/{cn}")
    public ResponseModel<List<VideoOriginalDto>> videoBySimilar( @PathVariable String cn) throws Exception {
        return ResponseHelper.buildResponse(videoOriginalServiceImpl.qeueryByKeys(cn));
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "根据indexCode获取播放URL", notes = "根据indexCode获取播放URL")
    @GetMapping(value = "/url/video/{indexCode}")
    public ResponseModel<String> videoUrlByIndexCode( @PathVariable String indexCode) throws Exception {
        return ResponseHelper.buildResponse(videoOriginalServiceImpl.qeueryByIndexCode(indexCode));
    }
}
