package com.yeejoin.equipmanage.common.enums;


/**
 * 动态表单下拉枚举字典类型
 * @author DELL
 */

public enum GroupCodeEnum {

    /**
     * 所有建筑
     */
    ALL_BUILDING("全部建筑","allBuilding",""),
    BUILDING("建(构)筑","building","JGZ"),
    FIRE_CONTROL_ROOM("消防控制室","fireControlRoom","XKS"),
    POOL("消防水池","pool","SC"),
    FIRE_ROOM("消防小室","fireRoom","XFXS"),
    RAIN_ROOM("雨淋阀间","rainRoom","YLFJ"),
    FIRE_FOAM_ROOM("消防泡沫间","fireFoamRoom","PMJ"),
    R_ELSE("其他","r_else","QT"),
    R_POOL("消防水池","r_pool","SC"),
    R_FIRE_ROOM("消防小室","r_fireRoom","XFXS"),
    R_RAIN_ROOM("雨淋阀间","r_rainRoom","YLFJ"),
    R_FIRE_FOAM_ROOM("消防泡沫间","r_fireFoamRoom","PMJ"),
    R_FIRE_CONTROL_ROOM("消防控制室","r_fireControlRoom","XKS"),
    FLOOR("楼层","floor","LC"),
    PMYG("泡沫液罐","92031900","PMYG"),
    GWYLTCQ("管网压力探测器","92011000","GWYLTCQ"),
    XFSCZZ("消防水池装置","92010700","XFSCZZ");

    private String groupName;
    private String groupCode;
    private String sequenceType;

    GroupCodeEnum(String groupName,String groupCode, String sequenceType) {
        this.groupName = groupName;
        this.groupCode = groupCode;
        this.sequenceType = sequenceType;
    }

    public static GroupCodeEnum getInstance(String groupCode) {
        GroupCodeEnum dataOption = null;
        for (GroupCodeEnum option : GroupCodeEnum.values()) {
            if (option.getGroupCode().contains(groupCode)){
                dataOption = option;
            }
        }
        return dataOption;
    }

    public String getGroupCode() {
        return groupCode;
    }

    public String getSequenceType() {
        return sequenceType;
    }

    public void setSequenceType(String sequenceType) {
        this.sequenceType = sequenceType;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }
}
