package com.yeejoin.equipmanage.service.impl;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.DataNotFound;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.equipmanage.common.entity.MonitorEvent;
import com.yeejoin.equipmanage.common.entity.Video;
import com.yeejoin.equipmanage.common.entity.VideoSource;
import com.yeejoin.equipmanage.common.entity.dto.MonitorEventDto;
import com.yeejoin.equipmanage.common.utils.UUIDUtils;
import com.yeejoin.equipmanage.fegin.JcsFeign;
import com.yeejoin.equipmanage.mapper.MonitorEventMapper;
import com.yeejoin.equipmanage.service.IVideoService;
import com.yeejoin.equipmanage.service.IVideoSourceService;

/**
 * 
 * <pre>
 * 在岗监测事件 服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: MonitorEventService.java, v 0.1 2021年9月10日 下午7:32:59 gwb Exp $
 */
@Component
public class MonitorEventService
		extends BaseService<MonitorEventDto, MonitorEvent, MonitorEventMapper>
{

	@Autowired
	private IVideoService videoService;
	
	@Autowired
	private MonitorEventMapper monitorEventMapper;
	
    @Autowired
    private JcsFeign jcsFeign;
    
    @Autowired
    private IVideoSourceService videoSourceService;
	
	
	public MonitorEventDto createMonitorEvent(MonitorEventDto model)
	{
		List<Video> videoList = videoService.listByCode(model.getVideoCode());
		if (!ValidationUtil.isEmpty(videoList))
		{
			//填充视频信息
			Video video = videoList.get(0);
			model.setVideoId(video.getId());
			model.setVideoMonitorPosition(video.getBelongAreaId());
			model.setVideoName(video.getName());
			model.setVideoPosition(video.getPresetPosition());
			//填充值班信息
			QueryWrapper<VideoSource> videoSourceQueryWrapper = new QueryWrapper<>();
		    videoSourceQueryWrapper.in("video_id", video.getId());
		    VideoSource videoSource = videoSourceService.getOne(videoSourceQueryWrapper);
		    if (!ValidationUtil.isEmpty(videoSource))
			{
		    	ResponseModel<Object> dutyListResponse = jcsFeign.findByDutyAreaId(videoSource.getSourceId());
		    	if (!ValidationUtil.isEmpty(dutyListResponse.getResult()))
				{
		    		String jsonString = JSONObject.toJSONString(dutyListResponse.getResult());
		    		model.setOnduty(jsonString);
				}
			}
		}
		model.setId(UUIDUtils.getUUIDInOrderId().longValue());
		monitorEventMapper.saveEvent(model);
		return model;
	}

	public MonitorEventDto udpateMonitorEvent(MonitorEventDto model, AgencyUserModel agencyUserModel)
	{
		MonitorEventDto oldModel = this.queryBySeq(model.getId());
		
		if (ValidationUtil.isEmpty(oldModel))
		{
			throw new DataNotFound("找不到监测事件信息");
		}
		Bean.copyExistPropertis(model, oldModel);
		
		oldModel.setDisposalUserId(agencyUserModel.getUserId());
		//oldModel.setDisposalUserName(agencyUserModel.getUserName());
		oldModel.setDisposalDate(new Date());
		
		this.updateWithModel(oldModel);
		
		return oldModel;
	}
	
	public MonitorEventDto udpateMonitorView(MonitorEventDto model, Long id)
	{
		MonitorEventDto oldModel = this.queryBySeq(id);

		if (!ValidationUtil.isEmpty(oldModel))
		{
			Bean.copyExistPropertis(model, oldModel);
			this.updateWithModel(oldModel);
		}
		else
		{
			throw new DataNotFound("找不到在岗监测事件信息");
		}
		return oldModel;
	}

	public MonitorEventDto queryById(Long id)
	{
		MonitorEventDto model = this.queryBySeq(id);
		return model;
	}

	public Page<MonitorEventDto> queryPage(Page<MonitorEventDto> page,
			String eventType, String eventState,
			@Condition(Operator.like) String videoCode, Date eventDate)
	{
		return this.queryForPage(page, "event_date", false, eventType,
				eventState, videoCode, eventDate);
	}


	public Page<MonitorEventDto> queryPage(Page<MonitorEventDto> page,
			String eventType, String eventState,
			@Condition(Operator.like) String videoCode, @Condition(Operator.between) Date[] eventDate)
	{
		return this.queryForPage(page, "event_date", false, eventType,
				eventState, videoCode, eventDate);
	}
}
