package com.yeejoin.amos.boot.module.tdc.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @author xxz
 */
@Data
@Accessors(chain = true)
@TableName("tdc_model_item")
@ApiModel(value="ModelItem对象", description="模型填报项表")
public class ModelItem {

    private static final long serialVersionUID = 1L;

    @TableId(value = "sequence_nbr", type = IdType.ID_WORKER)
    protected Long sequenceNbr;

    @ApiModelProperty(value = "校验项名称")
    private String checkItemLabel;

    @ApiModelProperty(value = "校验项值")
    private String checkItemValue;

    @ApiModelProperty(value = "模型名称")
    private String modelName;

    @ApiModelProperty(value = "提交记录id")
    private long submitRecordId;

    @ApiModelProperty(value = "标签名称")
    private String tagName;

    @ApiModelProperty(value = "类型")
    private int type = -1;

}
