package com.yeejoin.amos.boot.module.tdc.api.enums;

import java.util.HashMap;
import java.util.Map;

public enum ReportStateEnum {
    WAIT_FILL_IN("0", "待填报", "waitFillIn"),
    WAIT_HANDLE("1", "待处理", "waitHandle"),
    HANDLED("2", "已处理", "handled"),
    MY_CREATE("3", "我发起", "myCreate"),
    IN_PROGRESS("4", "进行中", "inProgress");

    private String status;
    private String state;
    private String IState;

    ReportStateEnum(String status, String state, String IState) {
        this.status = status;
        this.state = state;
        this.IState = IState;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getIState() {
        return IState;
    }

    public void setIState(String IState) {
        this.IState = IState;
    }

    public static final Map<String, String> map = new HashMap<>();


    public static String getStateValue(String status){
        return map.get(status);
    }

    static {
        for(ReportStateEnum reportStateEnum: ReportStateEnum.values()){
            map.put(reportStateEnum.getStatus(),reportStateEnum.getState());
        }
    }
}
