package com.yeejoin.precontrol.common.enums;

public enum TaskRiskControlStatusEnum {
    notStart("notStart", "未开始", "0"),
    processing("processing", "进行中", "1,2,3,4,5"),
    finished("finished", "已完成", "99");

    private String code;
    private String name;
    private String stage;

    TaskRiskControlStatusEnum(String code, String name, String stage) {
        this.code = code;
        this.name = name;
        this.stage = stage;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStage() {
        return stage;
    }

    public void settage(String stage) {
        this.stage = stage;
    }

    public static String getNameByCode(String code) {
        String name = null;
        for (TaskRiskControlStatusEnum enumOne : TaskRiskControlStatusEnum.values()) {
            if (enumOne.getCode().equals(code)) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }

    public static TaskRiskControlStatusEnum getEnumByCode(String code) {
        for (TaskRiskControlStatusEnum enumOne : TaskRiskControlStatusEnum.values()) {
            if (enumOne.getCode().equals(code)) {
                return enumOne;
            }
        }
        return null;
    }
}
