package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.entity.CompanyQualificationsAttachment;
import com.yeejoin.precontrol.common.mapper.CompanyQualificationsAttachmentMapper;
import com.yeejoin.precontrol.common.service.ICompanyQualificationAttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 企业资质信息附件 服务实现类
 *
 * @author sqy
 */
@Service
public class CompanyQualificationAttachmentServiceImpl extends ServiceImpl<CompanyQualificationsAttachmentMapper, CompanyQualificationsAttachment> implements ICompanyQualificationAttachmentService {
    @Autowired
    private CompanyQualificationsAttachmentMapper qualificationsAttachmentMapper;
    @Value("${fileserver.domain}")
    String fileServerUrl;

    @Override
    public void saveAttach(Long qualificationId, List<CompanyQualificationsAttachment> attachment) {
        qualificationsAttachmentMapper.delete(new QueryWrapper<CompanyQualificationsAttachment>().lambda()
                .eq(CompanyQualificationsAttachment::getCompanyQualificationsId, qualificationId));
        if (attachment != null) {
            attachment.forEach(a -> {
                a.setCompanyQualificationsId(qualificationId);
                a.setAttachment(a.getAttachment().replace(fileServerUrl, ""));
                qualificationsAttachmentMapper.insert(a);
            });
        }
    }
}
