package com.yeejoin.amos.supervision.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum PlanTaskFinishStatusEnum {
	NOTSTARTED("未开始",0),
	UNDERWAY("执行中",1),
	FINISHED("已结束",2),
	OVERTIME("已超时",3);
	
	/**
	 * 名称
	 */
	private String name;

	/**
	 * 值
	 */
	private int value;
	


	private PlanTaskFinishStatusEnum(String name, int value) {
		this.name = name;
		this.value = value;
	}


	public static String getName(int value) {
		for (PlanTaskFinishStatusEnum c : PlanTaskFinishStatusEnum.values()) {
			if (c.getValue() == value) {
				return c.name;
			}
		}
		return null;
	}
	
	public static int getValue(String name) {
		for (PlanTaskFinishStatusEnum c : PlanTaskFinishStatusEnum.values()) {
			if (c.getName().equals(name)) {
				return c.value;
			}
		}
		return -1;
	}


	public static PlanTaskFinishStatusEnum getEnum(int value) {
		for (PlanTaskFinishStatusEnum c : PlanTaskFinishStatusEnum.values()) {
			if (c.getValue() == value) {
				return c;
			}
		}
		return null;
	}


	public static PlanTaskFinishStatusEnum getEnum(String name) {
		for (PlanTaskFinishStatusEnum c : PlanTaskFinishStatusEnum.values()) {
			if (c.getName().equals(name)) {
				return c;
			}
		}
		return null;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> nameList = new ArrayList<>();
		for (PlanTaskFinishStatusEnum c: PlanTaskFinishStatusEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("name", c.getName());
			map.put("value", c.getValue() +"");
			nameList.add(map);
		}
		return nameList;
	}
	
	public static List<String> getEnumNameList() {
		List<String> nameList = new ArrayList<String>();
		for (PlanTaskFinishStatusEnum c: PlanTaskFinishStatusEnum.values()) {
			nameList.add(c.getName());
		}
		return nameList;
	}

	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}


	public int getValue() {
		return value;
	}


	public void setValue(int value) {
		this.value = value;
	}
}
