package com.yeejoin.amos.fas.business.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;

@RestController
@RequestMapping("/api/weather")
@Api(tags="天气api")
public class WeatherController extends AbstractBaseController {
	
	@Value("${param.weather.url}")
    private String weatherUrl;

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "天气查询", notes = "天气查询")
	@GetMapping("/{address}")
	public CommonResponse getWeather(@PathVariable("address") String address) {

		String result = "";
        BufferedReader in = null;
        try {
            String urlNameString = weatherUrl + address;
            URL realUrl = new URL(urlNameString);
            
            // 打开和URL之间的连接
            URLConnection connection = realUrl.openConnection();
            
            // 设置通用的请求属性
            connection.setRequestProperty("Accept", "*/*");
            connection.setRequestProperty("Connection", "Keep-Alive");
            connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
//            connection.setRequestProperty("Charset", "utf-8");
            connection.setRequestProperty("Accept-Encoding", "gzip, deflate, br");
            connection.setUseCaches(false);  
            // 建立实际的连接
            connection.connect();
            
            StringBuffer sb = new StringBuffer();
            String readLine = new String();
            GZIPInputStream gZipS=new GZIPInputStream(connection.getInputStream());
            InputStreamReader res = new InputStreamReader(gZipS,"UTF-8");
            BufferedReader responseReader = new BufferedReader(res);
            while ((readLine = responseReader.readLine()) != null) {
                sb.append(readLine);
            }
            responseReader.close();
            result = sb.toString();
            System.out.println(result);
   
        } catch (Exception e) {
            System.out.println("发送GET请求出现异常！" + e);
            return CommonResponseUtil.failure(e.getMessage());
        }
        
        // 使用finally块来关闭输入流
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (Exception e2) {
                e2.printStackTrace();
            }
        }
		
		return CommonResponseUtil.success(JSONObject.parse(result));
	}
	
}
