package com.yeejoin.amos.fas.business.util;

import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.common.request.CommonRequest;
import org.springframework.util.CollectionUtils;

import java.util.List;

public class CommonPageParamUtil {

	public static CommonPageInfoParam fillCommonPageInfoParam(List<CommonRequest> queryRequests, CommonPageable commonPageable) {	
		CommonPageInfoParam param = new CommonPageInfoParam();
		for(int i=0;i<queryRequests.size();i++){
			String name = queryRequests.get(i).getName();
			if("name".equals(name)){
				param.setName(toString(queryRequests.get(i).getValue()));
			}else if("equipType".equals(name)){
				param.setEquipType(toString(queryRequests.get(i).getValue()));
			}else if("productArea".equals(name)){
				param.setProductArea(toString(queryRequests.get(i).getValue()));
			}else if("protectObj".equals(name)){
				param.setProtectObj(toString(queryRequests.get(i).getValue()));
			}else if("evalModelId".equals(name)){
				param.setEvalModelId(toLong(queryRequests.get(i).getValue()));
			}else if("equipClassify".equals(name)){
				param.setEquipClassify(toLong(queryRequests.get(i).getValue()));
			}else if("id".equals(name)){
				param.setId(toLong(queryRequests.get(i).getValue()));
			}else if("code".equals(name)){
				param.setCode(toString(queryRequests.get(i).getValue()));
			}else if("beginDate".equals(name)){
				param.setBeginDate(toString(queryRequests.get(i).getValue()));
			}else if("endDate".equals(name)){
				param.setEndDate(toString(queryRequests.get(i).getValue()));
			}else if("riskSourceId".equals(name)){
				param.setRiskSourceId(toLong(queryRequests.get(i).getValue()));
			}
		}		
		if(commonPageable !=null){
			param.setPageNumber(commonPageable.getPageNumber());
			param.setPageSize(commonPageable.getPageSize());	
		}
		return param;
	}
	
	private static String toString(Object value) {
		if(null ==value || value ==""){
			return null;
		}else{
			return value.toString();
		}		
	}
	
	private static Long toLong(Object value) {
		if(null ==value || value ==""){
			return null;
		}else{
			return Long.parseLong(value.toString());
		}		
	}


	public static Object getValue(String propertyName,List<CommonRequest> queryRequests)
	{
		Object  value = null;
		if(!CollectionUtils.isEmpty(queryRequests))
		{
			for(CommonRequest request : queryRequests)
				if(propertyName.equals(request.getName()))
					value = request.getValue();
		}
		return value;
	}

}
