package com.yeejoin.amos.boot.module.tdc.api.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.tdc.api.entity.ModelItem;
import com.yeejoin.amos.boot.module.tdc.api.entity.SubmitRecord;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @author xxz
 */
@Service
public interface ModelItemService extends IService<ModelItem> {

    SubmitRecord saveModelItem(JSONObject jsonObject, AgencyUserModel userInfo, int draft,  ReginParams reginParams);

    SubmitRecord editModelItem(JSONObject jsonObject, AgencyUserModel userInfo, int draft, Long id, int examine,  ReginParams reginParams);

    /**
     * 获取详情接口
     * @param sequenceNbr 记录id
     * @return 项
     */
    Map<String, Object> getModelItem(Long sequenceNbr);

    void deleteModelItem(String sequenceNbr);
}
