package com.yeejoin.amos.api.openapi.face.orm.entity;

import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

/**
 * 许可基本信息表
 *
 * @author duanwei
 * @date 2022-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value="TaLicenseBaseInfo对象", description="许可基本信息表")
public class TaLicenseBaseInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "国家")
    private String country;

    @ApiModelProperty(value = "省")
    private String province;

    @ApiModelProperty(value = "市")
    private String city;

    @ApiModelProperty(value = "区")
    private String district;

    @ApiModelProperty(value = "单位名称")
    private String unitName;

    @ApiModelProperty(value = "单位代码")
    private String unitCode;

    @ApiModelProperty(value = "注册地址")
    private String regAddress;

    @ApiModelProperty(value = "证件地址")
    private String licAddress;

    @ApiModelProperty(value = "证件类型")
    private String certType;

    @ApiModelProperty(value = "证件许可项目")
    private String certItem;

    @ApiModelProperty(value = "证件编号")
    private String certNo;

    @ApiModelProperty(value = "有效截止日期")
    private Date expiryDate;

    @ApiModelProperty(value = "发证日期")
    private Date issueDate;

    @ApiModelProperty(value = "发证机关")
    private String approvedOrgan;

    @ApiModelProperty(value = "变更日期")
    private Date changeDate;

    @ApiModelProperty(value = "许可方式")
    private String applyType;

    @ApiModelProperty(value = "许可评审方式")
    private String appraisalType;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "数据入库时间")
    private Date recordDate;



    @ApiModelProperty(value = "同步时间")
    private Date syncDate;

    @ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
    private Integer syncState;


}
