package com.yeejoin.equipmanage.service;

import com.yeejoin.equipmanage.common.vo.IotDataVO;
import com.yeejoin.equipmanage.common.vo.PressurePumpCountVo;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author GaoJianqiang
 * @date 2023/02/15 16:20
 */
public interface IPressurePumpService {


    /**
     * redis缓存物联采集数据，内部读取JSON配置指定有效期
     *
     * @param iotDatalist
     * @param topic
     */
    void saveDataToRedis(List<IotDataVO> iotDatalist, String topic);

    /**
     * 根据nameKey，模糊查询所有的redis缓存数据
     * @param infoCode
     * @param nameKey
     * @param iotCode
     * @return
     */
    List<IotDataVO> getDataToRedis(String infoCode, String nameKey, String iotCode);

    /**
     * 获取指标配置JSON信息集合
     * @param code
     */
    List<Map> getNameKeyInfoList(String code);

    /**
     * 获取所有稳压泵最近一次启停间隔，min
     *
     * @param dataList
     * @param dataListFilterTrue
     * @param dataListFilterFalse
     * @param nowStrLong
     */
    long getAllPressurePumpStartStopInterval(List<IotDataVO> dataList, List<IotDataVO> dataListFilterTrue, List<IotDataVO> dataListFilterFalse, String nowStrLong);

    /**
     * 获取稳压泵一定时间内启动频率或次数
     *
     * @param hour
     * @param dataList
     * @param dateNow
     */
    int getAllPressurePumpStartFrequency(double hour, List<IotDataVO> dataList, Date dateNow);

    /**
     * 获取稳压泵最近一次启停时长，min
     *
     * @param dataList
     * @param dataListFilterTrue
     * @param dataListFilterFalse
     * @param nowStrLong
     */
    long getAllPressurePumpStartStopDuration(List<IotDataVO> dataList, List<IotDataVO> dataListFilterTrue, List<IotDataVO> dataListFilterFalse, String nowStrLong);

    /**
     * 获取稳压泵指定启泵前 minutes 分钟，管网压力差绝对值
     * @param dataList
     * @param dataPipeList
     * @param minutes
     * @return
     */
    double getAllPressurePumpPipePressureDiff(List<IotDataVO> dataList, List<IotDataVO> dataPipeList, String minutes);

    /**
     * 根据指标，获取物联top数据，influxdb
     * @param top
     * @param productKey
     * @param deviceName
     * @param key
     * @param fieldKey
     */
    List<Map<String, String>> getIotTopSingleField(String top, String productKey, String deviceName, String key, String fieldKey);

    /**
     * 根据时间范围，获取redis指定指标或指定指标设备的缓存数据
     * @param infoCode
     * @param nameKey
     * @param iotCode
     * @param startDate
     * @param endDate
     */
    List<IotDataVO> getDataToRedisByDateBetween(String infoCode, String nameKey, String iotCode, Date startDate, Date endDate);

    /**
     * 根据时间范围获取iot物联数据集合
     * @param startTime
     * @param endTime
     * @param prefix
     * @param suffix
     * @param key
     * @param fieldKey
     */
    List<Map<String, String>> getIotCommonListData(String startTime, String endTime, String prefix, String suffix, String key, String fieldKey);

    /**
     * 数据根据指定值过滤
     * @param dataList
     * @param value
     */
    List<IotDataVO> getDataListFilter(List<IotDataVO> dataList, String value);

    /**
     * 获取稳压泵数据，redis没有，从iot取
     *
     * @param infoCode
     * @param equipmentCode
     * @param top
     * @param nameKey
     * @param bizOrgCode
     * @param iotCode
     * @return
     */
    Map<String, List<IotDataVO>> getDataList(String infoCode, String equipmentCode, String top, String nameKey, String bizOrgCode, String iotCode);

    /**
     * map 转化为对象
     * @param map
     * @param aClass
     * @return
     */
    Object mapToObject(Map<String,String> map,Class<?> aClass, String indexKey) throws IllegalAccessException, InstantiationException;

    /**
     * 获取iot指标统计数据
     * @param startTime
     * @param endTime
     * @param infoCode
     * @param countRedisKey
     * @param prefix
     * @param suffix
     * @param key
     * @param fieldKey
     * @param expire
     * @return
     */
    List<PressurePumpCountVo> getIotCountData(String startTime, String endTime, String infoCode, String countRedisKey, String prefix, String suffix, String key, String fieldKey, long expire);

    /**
     * 获取稳压泵时间范围统计数据
     * @param pumpInfoList
     * @param startTime
     * @param endTime
     * @param infoCode
     * @param countRedisKey
     * @param equipmentCode
     * @param nameKey
     * @param countExpire
     * @param bizOrgCode
     * @return
     */
    Map<String, List<PressurePumpCountVo>> getDateRangeCountList(List<Map<String, Object>> pumpInfoList, String startTime, String endTime, String infoCode, String countRedisKey, String equipmentCode, String nameKey, long countExpire, String bizOrgCode);
}
