package com.yeejoin.amos.boot.module.jcs.biz.audioToText;


import lombok.Data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * 音频关键字结果集
 */
@Data
public class AudioKeyWord {
    private Map<String, Set<String>> values;

    public AudioKeyWord() {
        values = new HashMap<>();
        //地址
        values.put(AudioKeywordType.LOCATION.getType(), new HashSet<>());
        //联系人
        values.put(AudioKeywordType.CONTACT.getType(), new HashSet<>());
        //联系电话
        values.put(AudioKeywordType.CONTACT_NUMBER.getType(), new HashSet<>());
        //事发单位
        values.put(AudioKeywordType.UNIT.getType(), new HashSet<>());
        //重点部位
        values.put(AudioKeywordType.PART.getType(), new HashSet<>());
    }

    public Map<String, Set<String>> getValues() {
        return values;
    }

    public void setValues(Map<String, Set<String>> values) {
        this.values = values;
    }
}