package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.api.dto.ShCarDto;
import com.yeejoin.amos.boot.module.jg.api.entity.ShCar;
import com.yeejoin.amos.boot.module.jg.api.entity.ShCarEqu;
import com.yeejoin.amos.boot.module.jg.api.mapper.ShCarEquMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IShCarEquService;
import com.yeejoin.amos.boot.module.jg.api.vo.ShCarEquVo;
import com.yeejoin.amos.boot.module.jg.biz.service.ICommonService;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2024-11-08
 */
@Service
public class ShCarEquServiceImpl extends BaseService<ShCarEqu, ShCarEqu, ShCarEquMapper> implements IShCarEquService {

    @Autowired
    ShCarServiceImpl shCarServiceImpl;

    @Autowired
    ICommonService commonService;

    /**
     * 分页查询
     */
    public Page<ShCarEqu> queryForShCarEquPage(Page<ShCarEqu> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<ShCarEqu> queryForShCarEquList() {
        return this.queryForList("", false);
    }

    public Map<String,Object> queryByCarId(String carId,String claimOneself, ReginParams reginParams) {
        Map<String,Object> result = new HashMap<String,Object>();
        // 根据carId获取Car
        LambdaQueryWrapper<ShCar> queryWrapper1 = new LambdaQueryWrapper<>();
        queryWrapper1.eq(ShCar::getSequenceNbr, carId);
        ShCar shCar = shCarServiceImpl.getOne(queryWrapper1);
        ShCarDto shCarDto = new ShCarDto();
        BeanUtil.copyProperties(shCar, shCarDto);
        // 补充信息
        String companyType = reginParams.getCompany().getCompanyType();
        String companyLevel =  reginParams.getCompany().getLevel();
        AgencyUserModel userModel = reginParams.getUserModel();
        shCarDto.setCompanyType(companyType);
        String[] code = reginParams.getCompany().getCompanyCode().split("_");
        String useUnitCode = code.length > 1 ? code[1] : code[0];
        if ("true".equals(claimOneself)){//认领自己的
            shCarDto.setUseUnitName(reginParams.getCompany().getCompanyName());
            shCarDto.setUseUnitCreditCode(reginParams.getCompany().getCompanyCode());
            if ("个人主体".equals(companyType)) {
                shCarDto.setUseUnitAddress((String) commonService.getEnterpriseInfo(useUnitCode).get("address"));
            } else {
                shCarDto.setUseUnitAddress(reginParams.getCompany().getAddress());
            }
        }
        if ("false".equals(claimOneself) || !BaseController.COMPANY_TYPE_COMPANY.equals(companyLevel)) {// 帮别人或监管认领 取 原三环数据填充表单
            shCarDto.setUseUnitName(shCar.getOwner());
            shCarDto.setUseUnitCreditCode(shCar.getOwner());
            shCarDto.setUseUnitAddress(shCar.getAddress());
        }
        shCarDto.setSafetyManagerId("个人主体".equals(companyType) ? userModel.getRealName() : null);
        shCarDto.setPhone("个人主体".equals(companyType) ? userModel.getMobile() : null);
        if (!ValidationUtil.isEmpty(shCarDto.getVehicleAttribute())){
            switch (shCarDto.getVehicleAttribute()) {
                case "A":
                    shCarDto.setVehicleAttribute("PRIVATE_CAR");
                    break;
                case "B":
                    shCarDto.setVehicleAttribute("BUS");
                    break;
                case "H":
                    shCarDto.setVehicleAttribute("SERVICE_VEHICLE");
                    break;
                case "P":
                    shCarDto.setVehicleAttribute("SERVICE_CAR");
                    break;
                case "V":
                    shCarDto.setVehicleAttribute("MINIVAN");
                    break;
                case "X":
                    shCarDto.setVehicleAttribute("OTHER");
                    break;
                case "T":
                    shCarDto.setVehicleAttribute("TAXI");
                    break;
                case "J":
                    shCarDto.setVehicleAttribute("TRAINING_CAR");
                    break;
                default:
                    shCarDto.setVehicleAttribute("OTHER");
            }
        }
        if("原车".equals(shCarDto.getCylinderInstallationMethod())){
            shCarDto.setCylinderInstallationMethod("ORIGINAL_CAR");
        }else if("加装".equals(shCarDto.getCylinderInstallationMethod())){
            shCarDto.setCylinderInstallationMethod("RELOADING");
        }
        // 根据carId获取设备列表
        LambdaQueryWrapper<ShCarEqu> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ShCarEqu::getCarId, carId);
        List<ShCarEqu> list = this.list(queryWrapper);
        // 将设备列表转换为前端可识别bean
        List<ShCarEquVo> collect = list.stream().map(shCarEqu -> {
            ShCarEquVo shCarEquVo = new ShCarEquVo(shCarEqu);
            shCarEquVo.setWhetherVehicleCylinder("1");
            shCarEquVo.setEquList("2000");
            shCarEquVo.setEquCategory("2300");
            shCarEquVo.setEquDefine("23T0");
            return shCarEquVo;
        }).collect(Collectors.toList());
        // 封装返回VO
        HashMap<String ,Object> hashMap = JSONObject.parseObject(JSON.toJSONString(shCarDto), HashMap.class);
        hashMap.put("equList", collect);
        hashMap.put("identificationCode", shCarDto.getFrameNumber());
        result.put("completeDataSanHuan", hashMap);

        // 帮别人认领 + 单位变更给自己
        if ("false".equals(claimOneself)){
            HashMap<String, Object> gasCylinderChangeObj = new HashMap<>();
            if ("个人主体".equals(companyType)) {
                String[] companyName = reginParams.getCompany().getCompanyName().split("_");
                String newUseUnitCreditCodeStr = companyName.length > 1 ? companyName[1] : companyName[0];
                gasCylinderChangeObj.put("newUseUnitCreditCode", newUseUnitCreditCodeStr);// 使用单位
                gasCylinderChangeObj.put("address",commonService.getEnterpriseInfo(useUnitCode).get("address"));
                gasCylinderChangeObj.put("companyType", "person");
            } else {
                gasCylinderChangeObj.put("newUseUnitCreditCode", reginParams.getCompany().getCompanyName());// 使用单位
                gasCylinderChangeObj.put("address",commonService.getEnterpriseInfo(reginParams.getCompany().getCompanyCode()).get("address"));
                gasCylinderChangeObj.put("companyType", "company");
            }
            gasCylinderChangeObj.put("useRegistrationCode",shCarDto.getUseRegistrationCode());
            gasCylinderChangeObj.put("carNumber",shCarDto.getCarNumber());
            result.put("gasCylinderChange",gasCylinderChangeObj);
        }

        return result;
    }


}