package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 库存明细
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_stock_detail")
@ApiModel(value = "StockDetail对象", description = "库存明细")
public class StockDetail extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "库存数量")
	private Double amount;

	@ApiModelProperty(value = "库存ID")
	private Long stockId;

	@ApiModelProperty(value = "货位ID")
	private Long warehouseStructureId;

	@ApiModelProperty(value = "批次号")
	private String batchNum;

    @ApiModelProperty(value = "RFID标识")
	private String rfid;

	@ApiModelProperty(value = "装修详情定义id")
	private Long equipmentDetailId;

	@TableField(exist = false)
	private EquipmentDetail equipmentDetail;

	@ApiModelProperty(value = "仓库id")
	private Long warehouseId;

	@ApiModelProperty(value = "二维码")
	private String qrCode;

	@ApiModelProperty(value = "状态")
	private String status;

	@ApiModelProperty(value = "位置描述")
	private String description;

	@ApiModelProperty(value = "更新时间")
	@TableField(value = "update_date", fill = FieldFill.UPDATE)
	private Date updateDate;

	@ApiModelProperty(value = "公司名称")
	@TableField(value = "company_name", fill = FieldFill.INSERT)
	private String companyName;

	@ApiModelProperty(value = "公司code")
	@TableField(value = "org_code", fill = FieldFill.INSERT)
	private String orgCode;

	@ApiModelProperty(value = "部门名称")
	@TableField(value = "department_name", fill = FieldFill.INSERT)
	private String departmentName;

	@ApiModelProperty(value = "部门code")
	@TableField(value = "department_orgcode", fill = FieldFill.INSERT)
	private String departmentOrgcode;

	@ApiModelProperty(value = "单个设备ID")
	@TableField(value = "equipment_specific_id", fill = FieldFill.INSERT)
	private Long equipmentSpecificId;

	@TableField(exist = false)
	private String img;

	@ApiModelProperty(value = "位置信息")
	private String area;
}
