package com.yeejoin.precontrol.common.publish;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.precontrol.common.listener.event.MessageEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

/**
 * @description:
 * @author: tb
 * @date: 2021-02-23 17:22
 **/
@Component
public class MessageEventPublish extends AbstractEventPublish {

    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    public void publish(String message) {
        MessageEvent messageEvent = new MessageEvent(this, message);
        applicationEventPublisher.publishEvent(messageEvent);
    }

    public void publish(JSONObject message) {
        MessageEvent messageEvent = new MessageEvent(this, message);
        applicationEventPublisher.publishEvent(messageEvent);
    }

}
