package com.yeejoin.precontrol.common.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.module.common.api.dto.CreatExamDto;
import com.yeejoin.precontrol.common.dto.*;
import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.entity.Task;
import com.yeejoin.precontrol.common.vo.ReginParams;
import com.yeejoin.precontrol.common.vo.RewardAndRetributionListVo;
import com.yeejoin.precontrol.common.vo.TaskPageVo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 作业活动 服务类
 *
 * @author duanwei
 * @date 2020-06-30
 */
public interface ITaskService extends IService<Task> {
	/**
	 * 任务分页查询
	 * 
	 * @param pageable
	 * @param taskPageDto
	 * @return
	 */
	IPage<TaskPageVo> listByPage(CommonPageableDto pageable, TaskPageDto taskPageDto);

	/**
	 * 我的待办
	 * 
	 * @param pageable
	 * @param taskPageDto
	 * @return
	 */
	IPage<TaskPageVo> myToDoListByPage(CommonPageableDto pageable, TaskPageDto taskPageDto, Long personId);

	/**
	 * 安全施工作业统计
	 * 
	 * @param pageable
	 * @param safeConstructionDto
	 * @return
	 */
	IPage<TaskPageVo> safeConstructionTaskStatusList(CommonPageableDto pageable,
			SafeConstructionDto safeConstructionDto);

	/**
	 * 危险作业
	 * 
	 * @param pageable
	 * @param startTime
	 * @param endTime
	 * @param safeOperationStatisticsDto
	 * @return
	 */
	IPage<TaskPageVo> riskWork(CommonPageableDto pageable, String startTime, String endTime,
			SafeOperationStatisticsDto safeOperationStatisticsDto);

	/**
	 * 技术交底
	 * 
	 * @param pageable
	 * @param startDate
	 * @param endDate
	 * @param safeOperationStatisticsDto
	 * @return
	 */
	IPage<TaskPageVo> jobTicket(CommonPageableDto pageable, String startDate, String endDate,
			SafeOperationStatisticsDto safeOperationStatisticsDto);

	/**
	 * 任务列表
	 * 
	 * @param pageable
	 * @param type
	 * @param startTime
	 * @param endTime
	 * @param safeOperationStatisticsDto
	 * @return
	 */
	IPage<TaskPageVo> taskList(CommonPageableDto pageable, String type, String startTime, String endTime,
			SafeOperationStatisticsDto safeOperationStatisticsDto);

	/**
	 * 三交三查
	 * 
	 * @param commonPageableDto
	 * @param startTime
	 * @param endTime
	 * @param safeOperationStatisticsDto
	 * @return
	 */
	IPage<TaskPageVo> taskPay(CommonPageableDto commonPageableDto, String startTime, String endTime,
			SafeOperationStatisticsDto safeOperationStatisticsDto);

	/***
	 * 违规作业
	 * 
	 * @param commonPageableDto
	 * @param startTime
	 * @param endTime
	 * @param safeOperationStatisticsDto
	 * @return
	 */
	IPage<TaskPageVo> bad(CommonPageableDto commonPageableDto, String startTime, String endTime,
			SafeOperationStatisticsDto safeOperationStatisticsDto);

	/**
	 * 保存技术交底
	 * 
	 * @param singJobDisclosureDto
	 * @param person
	 * @return
	 */
	Task saveJobDisclosure(SingJobDisclosureDto singJobDisclosureDto, Person person);

	/**
	 * 保存三交三查
	 * 
	 * @param singTaskPayCheckDto
	 * @param person
	 * @return
	 */
	Task saveTaskPayCheck(SingTaskPayCheckDto singTaskPayCheckDto, Person person);

	/**
	 * 更新三交三查
	 * 
	 * @param singTaskPayCheckDto
	 * @param person
	 */
	void updatePayCheck(SingTaskPayCheckDto singTaskPayCheckDto, Person person);

	/**
	 * 保存违规任务
	 * 
	 * @param singBadManagementDto
	 * @param curPerson
	 */
	void saveBadManagement(SingBadManagementDto singBadManagementDto, Person curPerson);

	/**
	 * 更新违规任务
	 * 
	 * @param singBadManagementDto
	 */
	void updateBadManagement(SingBadManagementDto singBadManagementDto, Person curPerson);

	/**
	 * 查询技术交底
	 * 
	 * @param taskId
	 * @return
	 */
	Object getJobDisclosure(Long taskId,Long taskPersonId);

	/**
	 * 查询三交三查
	 *
	 * @param person
	 * @param taskId
	 * @return
	 */
	Object getTaskPayCheck(Long taskId,Long taskPersonId);

	/**
	 * 查询违规作业
	 * 
	 * @param taskId   任务id
	 * @param personId 当前登录人id
	 * @return
	 */
	Object getBadManagement(Long taskId, Long personId,Long taskPersonId);

	/**
	 * 根据id查询任务
	 * 
	 * @param id
	 * @return
	 */
	Object selectById(Long id,Long taskPersonId);

	/**
	 * 根据任务导出模板
	 * 
	 * @param id
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	String exportDoc(Long id, HttpServletRequest request, HttpServletResponse response) throws IOException;

	/**
	 * 重新提交 发布任务
	 * 
	 * @param singBadManagementDto
	 * @param person
	 */
	void recommitBadManagement(SingBadManagementDto singBadManagementDto, Person person);

	/**
	 * 查询对应权限的任务
	 * 
	 * @param reginInfo
	 * @param fbsRole
	 * @param pageable
	 * @param taskPageDto
	 * @param operType
	 * @param ids
	 * @param response
	 * @return
	 */
	Object list(ReginParams reginInfo, boolean fbsRole, CommonPageableDto pageable, TaskPageDto taskPageDto,
			Long operType, List<Long> ids, HttpServletResponse response);

	/**
	 * 获取三交三查发起人的数据
	 * 
	 * @param person
	 * @return
	 */
	Object createPersonTask(Person person);

	/**
	 * 获取任务数据-新版
	 * 
	 * @param id
	 * @return
	 */
	Object newSelectById(Long id,Long taskPersonId);

	/**
	 * 可视化三交三查
	 * 
	 * @param task
	 * @return
	 */
	Object visualTaskPayCheck(Task task);

	/**
	 * 可视化技术交底
	 * 
	 * @param task
	 * @return
	 */
	Object visualJobdisclosure(Task task);

	/**
	 * 可视化违规管理
	 * 
	 * @param task
	 * @return
	 */
	Object visualBad(Task task);

	/**
	 * 我的任务
	 * 
	 * @param pageable
	 * @param taskPageDto
	 * @return
	 */
	IPage<TaskPageVo> myListByPage(CommonPageableDto pageable, TaskPageDto taskPageDto);

	/**
	 * 根据考试模板发起考试
	 * 
	 * @return
	 */
	Long examTemplateTest(CreatExamDto creatExamDto);

	IPage<Object> violationRank(CommonPageableDto pageable, String key, String sortType, String orgCode, Long projectId);

	Integer sumTotal(String orgCode, Long projectId);

	List<Map> riskStatus(String orgCode, Long projectId);

	IPage<RewardAndRetributionListVo> violationList(StudioPageableDto pageable, RewardAndRetributionListVo rewardVo);
}
