package com.yeejoin.amos.supervision.common.enums;

/**
 * 规则请求枚举
 * @author WJK
 *
 */
public enum RuleTypeEnum {

	GETCONTENT("维保项获取","getContent"),
	CHECKRESULT("结果校验","checkResult" );

	/**
	 * 名称，描述
	 */
	private String name;
	/**
	 * 编码
	 */
	private String code;

	private RuleTypeEnum(String name, String code){
		this.name = name;
		this.code = code;
	}

	public static RuleTypeEnum getEnum(String code) {
		RuleTypeEnum jPushTypeEnum = null;
		for(RuleTypeEnum type: RuleTypeEnum.values()) {
			if (type.getCode().equals(code)) {
				jPushTypeEnum = type;
				break;
			}
		}

		return jPushTypeEnum;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

}
