package com.yeejoin.equipmanage.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarm;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarmLog;
import com.yeejoin.equipmanage.common.entity.FireFightingSystemEntity;
import com.yeejoin.equipmanage.common.entity.dto.EquipmentAlarmLogDto;
import com.yeejoin.equipmanage.common.entity.vo.EquiplistSpecificBySystemVO;
import com.yeejoin.equipmanage.common.utils.DateUtils;
import com.yeejoin.equipmanage.fegin.IotFeign;
import com.yeejoin.equipmanage.fegin.VideoFeignClient;
import com.yeejoin.equipmanage.mapper.EquipmentSpecificAlarmLogMapper;
import com.yeejoin.equipmanage.mapper.FireFightingSystemMapper;
import com.yeejoin.equipmanage.service.IESeqService;
import com.yeejoin.equipmanage.service.IEquipmentSpecificAlarmLogService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author keyong
 * @title: EquipmentSpecificAlarmLogServiceImpl
 * <pre>
 * @description:
 * </pre>
 * @date 2021/8/19 10:37
 */
@Service
public class EquipmentSpecificAlarmLogServiceImpl extends ServiceImpl<EquipmentSpecificAlarmLogMapper, EquipmentSpecificAlarmLog> implements IEquipmentSpecificAlarmLogService {

    @Autowired
    EquipmentSpecificAlarmLogMapper equipmentSpecificAlarmLogMapper;
    @Autowired
    FireFightingSystemMapper fireFightingSystemMapper;

    @Autowired
    VideoFeignClient videoFeignClient;

    @Autowired
    IotFeign iotFeign;
    @Autowired
    IESeqService eSeqService;

    @Override
    public void updateAlarmLogByIotCodeAndIndexKey(EquipmentSpecificAlarm equipmentSpecificAlarm) {
        equipmentSpecificAlarmLogMapper.updateAlarmLogByIotCodeAndIndexKey(equipmentSpecificAlarm);
    }

    @Override
    public List<EquipmentSpecificAlarmLog> getIsConfirmByAlarmId(Long equipmentSpecificId, String equipmentSpecificIndexKey, String isConfirm) {
        List<EquipmentSpecificAlarmLog> list = equipmentSpecificAlarmLogMapper.getIsConfirmByAlarmId(equipmentSpecificId, equipmentSpecificIndexKey, isConfirm);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Lists.newArrayList();
    }

    @Override
    public Map<String, Object> equipAlarmLink(String date) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtils.isBlank(date)) {
            date = DateUtils.convertDateToString(new Date(), "yyyy-MM-dd");
        }
        String monthDate = date.substring(0, 7);
        //  获取今日告警设备、日环比
        Map<String, Object> alarmEquipDayLink = equipmentSpecificAlarmLogMapper.alarmEquipLink(date, "%Y-%m-%d", null);
        //  获取今日告警设备、月环比
        Map<String, Object> alarmEquipMonthLink = equipmentSpecificAlarmLogMapper.alarmEquipLink(monthDate, "%Y-%m", null);
        //  获取未消除告警设备，日环比
        Map<String, Object> unCleanAlarmEquipDayLink = equipmentSpecificAlarmLogMapper.unCleanAlarmEquipLink(date, "%Y-%m-%d", "unClean");
        //  获取未消除告警设备，月环比
        Map<String, Object> unCleanAlarmEquipMonthLink = equipmentSpecificAlarmLogMapper.unCleanAlarmEquipLink(monthDate, "%Y-%m", "unClean");
        map.put("alarmEquipDayLink", alarmEquipDayLink);
        map.put("alarmEquipMonthLink", alarmEquipMonthLink);
        map.put("unCleanAlarmEquipDayLink", unCleanAlarmEquipDayLink);
        map.put("unCleanAlarmEquipMonthLink", unCleanAlarmEquipMonthLink);
        return map;
    }

    @Override
    public List<EquipmentSpecificAlarmLog> getAlarmLogInfoList(String equipmentCode, String nameKeys, String value, String isCleanTime, String bizOrgCode) {
        return equipmentSpecificAlarmLogMapper.getAlarmLogInfoList(equipmentCode, nameKeys, value, isCleanTime, bizOrgCode);
    }

    @Override
    public  Page<EquipmentAlarmLogDto> getEquipAlarmLog(String code, String startTime, String endTime,long pageSize, long current)  {
        Page<EquipmentAlarmLogDto> pageBean = new Page<EquipmentAlarmLogDto>(current,pageSize);
       try {
           QueryWrapper<FireFightingSystemEntity> wrapper = new QueryWrapper<>();
           wrapper.eq("code", code);
           FireFightingSystemEntity sys = fireFightingSystemMapper.selectOne(wrapper);
           if(sys==null){
               throw new BadRequest("系统不存在！");
           }
           String systemId =sys.getId().toString();
           //获取时间梭
           SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");


           Long LongstartTime=format.parse(startTime).getTime();

           Long LongendTime=format.parse(endTime.replace("00:00:00","23:59:59")).getTime();

           pageBean= eSeqService.findAllBySystemId(systemId,  LongstartTime, LongendTime, (int) pageSize,  (int)current);

       }catch (Exception e) {
           e.printStackTrace();
           throw  new BadRequest("系统异常");
       }
        return pageBean;
    }







    public void getEquiplistBySystemIdList(String id,  Map<String, EquiplistSpecificBySystemVO> map, List<String> iotCodes) {

        //获取系统下所有装备
        List<EquiplistSpecificBySystemVO> list = fireFightingSystemMapper.getEquiplistBySystemIdList(Long.valueOf(id));
        if (!list.isEmpty()) {
            for (EquiplistSpecificBySystemVO equiplistSpecificBySystemVO : list) {
                 map.put(equiplistSpecificBySystemVO.getIotCode()+equiplistSpecificBySystemVO.getIndexKey(),equiplistSpecificBySystemVO);
                 iotCodes.add(equiplistSpecificBySystemVO.getIotCode()+equiplistSpecificBySystemVO.getIndexKey());
            }
        }
    }




}