package com.yeejoin.amos.boot.module.jcs.biz.audioToText;

import lombok.Builder;
import lombok.Data;

/**
 * 音频文字识别结果
 */
@Data
@Builder
public class AudioRecord {
    /**
     * 说话角色
     */
    private String type;
    /**
     * 响应码 20000000 正常返回
     */
    private int status;
    /**
     * 句子索引
     */
    private int index;
    /**
     * 句子所在的任务id
     */
    private String taskId;
    /**
     * 状态
     */
    private String name;
    /***
     * 识别结果
     */
    private String message;
    /**
     * 结果置信度,0.0-1.0 值越大置信度越高
     */
    private double confidence;
    /***
     * sentenceBegin事件对应的时间
     */
    private long beginTime;
    /**
     * 当前已处理的音频时长，单位是毫秒
     */
    private long time;
}
