package com.yeejoin.amos.patrol.business.dto;

import cn.jiguang.common.utils.StringUtils;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.biz.common.excel.ExplicitConstraint;
import com.yeejoin.amos.patrol.common.enums.PointCheckTypeEnum;
import com.yeejoin.amos.patrol.common.enums.PointLevelEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@ApiModel(value = "InputItemExcelDto", description = "检查项")
@Data
public class InputItemExcelDto extends BaseDto {

    @ExcelProperty(value = "编号", index = 0)
    @ApiModelProperty(value = "检查项编号")
    private String itemNo;

    @ExcelProperty(value = "名称", index = 1)
    @ApiModelProperty(value = "检查项名称")
    private String name;

    @ExplicitConstraint(indexNum=2,source = {"选择","数字","文本"})
    @ExcelProperty(value = "检查项类型", index = 2)
    @ApiModelProperty(value = "检查项类型")
    private String itemType;

    @ExplicitConstraint(indexNum=3,source = {"一级","二级","三级","四级","五级"})
    @ExcelProperty(value = "检查项等级", index = 3)
    @ApiModelProperty(value = "检查项等级")
    private String level;

    @ExcelProperty(value = "检查方法", index = 4)
    @ApiModelProperty(value = "检查方法")
    private String checkMethod;

    @ExcelProperty(value = "评分项(选择)", index = 5)
    @ApiModelProperty(value = "评分项")
    private String dataJson;
    @ExcelProperty(value = "消防装备类型", index = 6)
    @ApiModelProperty(value = "消防装备类型")
    private String equipmentType;

    @ExcelProperty(value = "消防设施类型", index = 7)
    @ApiModelProperty(value = "消防设施类型")
    private String facilitiesType;

    @ExplicitConstraint(indexNum=8,source = {"是","否"})
    @ExcelProperty(value = "是否重点类型", index = 8)
    @ApiModelProperty(value = "重点类型")
    private String keyPartsType = "1";

    @ExplicitConstraint(indexNum=9,source = {"是","否"})
    @ExcelProperty(value = "是否自定义类型", index = 9)
    @ApiModelProperty(value = "自定义类型")
    private String customType = "1";

    @ExplicitConstraint(indexNum=10,source = {"外观检查","功能测试","环境检查","其他"})
    @ExcelProperty(value = "检查类型", index =10)
    @ApiModelProperty(value = "检查类型")
    private String inputClassify;

    @ExcelProperty(value = "拍照项(文本/选择)", index = 14)
    @ApiModelProperty(value = "拍照项")
    private Object pictureJson;

    @ExplicitConstraint(indexNum=11,source = {"是","否"})
    @ExcelProperty(value = "是否必填", index = 11)
    @ApiModelProperty(value = "是否必填")
    private String isMust = "0";

    @ExplicitConstraint(indexNum=12,source = {"是","否"})
    @ExcelProperty(value = "是否评分", index = 12)
    @ApiModelProperty(value = "是否评分")
    private String isScore = "0";

    @ExplicitConstraint(indexNum=13,source = {"始终合格","始终不合格","无内容合格","有内容合格"})
    @ExcelProperty(value = "合格判断方法(文本)", index = 13)
    @ApiModelProperty(value = "合格判断方法")
    private String checkType = "始终合格";

    @ExcelProperty(value = "默认输入值(文本/数字)", index = 17)
    @ApiModelProperty(value = "默认输入值")
    private String defaultValue;

    @ExcelProperty(value = "合格评分数(文本/数字)", index = 16)
    @ApiModelProperty(value = "合格评分数")
    private Integer okScore;

    @ExcelProperty(value = "不合格评分数(文本/数字)", index = 15)
    @ApiModelProperty(value = "不合格评分数")
    private Integer noScore;

    @ExcelProperty(value = "输入值单位(数字)", index = 27)
    @ApiModelProperty(value = "输入值单位")
    private String unit;

    @ExcelProperty(value = "有效值上限(数字)", index = 18)
    @ApiModelProperty(value = "有效值上限")
    private Integer validUp;

    @ExcelProperty(value = "有效值下限(数字)", index = 19)
    @ApiModelProperty(value = "有效值下限")
    private Integer validDown;

    @ExcelProperty(value = "合格值上限(数字)", index = 20)
    @ApiModelProperty(value = "合格值上限")
    private Integer okUp;

    @ExcelProperty(value = "合格值下限(数字)", index = 21)
    @ApiModelProperty(value = "合格值下限")
    private Integer okDown;

    @ExcelProperty(value = "强制校验，输入值不能大于有效值上限(数字)", index = 22)
    @ApiModelProperty(value = "强制校验，输入值不能大于有效值上限")
    private String checkValidUp = "false";

    @ExcelProperty(value = "强制校验，输入值不能小于有效值下限(数字)", index = 23)
    @ApiModelProperty(value = "强制校验，输入值不能小于有效值下限")
    private String checkValidDown = "false";

    @ExcelProperty(value = "合格判断，输入值大于合格值上限时为不合格(数字)", index = 24)
    @ApiModelProperty(value = "合格判断，输入值大于合格值上限时为不合格")
    private String checkOkUp = "false";

    @ExcelProperty(value = "合格判断，输入值小于合格值上限时为不合格(数字)", index = 25)
    @ApiModelProperty(value = "合格判断，输入值小于合格值上限时为不合格")
    private String checkOkDown = "false";

    @ExcelProperty(value = "小数点后位数(数字)", index = 26)
    @ApiModelProperty(value = "小数点后位数")
    private Integer precision;

    @ExcelIgnore
    private long id;
    @ExcelIgnore
    private long catalogId;

    @ExcelIgnore
    private String inputJson;

    @ExcelIgnore
    private String isMultiline;

    @ExcelIgnore
    private int orderNo;

    @ExcelIgnore
    private String orgCode;

    @ExcelIgnore
    private String remark;

    @ExcelIgnore
    private String riskDesc;

    /**
     * 新加字段
     */
    //单位code
    @ExcelIgnore
    private String bizOrgCode;
    //单位名称
    @ExcelIgnore
    private String bizOrgName;

    public Integer getValidUp() {
        return validUp;
    }

    public void setValidUp(Integer validUp) {
        this.validUp = validUp;
    }

    public Integer getValidDown() {
        return validDown;
    }

    public void setValidDown(Integer validDown) {
        this.validDown = validDown;
    }

    public Integer getOkUp() {
        return okUp;
    }

    public void setOkUp(Integer okUp) {
        this.okUp = okUp;
    }

    public Integer getOkDown() {
        return okDown;
    }

    public void setOkDown(Integer okDown) {
        this.okDown = okDown;
    }

    public String getCheckValidUp() {
        return checkValidUp;
    }

    public void setCheckValidUp(String checkValidUp) {
        this.checkValidUp = checkValidUp;
    }

    public String getCheckValidDown() {
        return checkValidDown;
    }

    public void setCheckValidDown(String checkValidDown) {
        this.checkValidDown = checkValidDown;
    }

    public String getCheckOkUp() {
        return checkOkUp;
    }

    public void setCheckOkUp(String checkOkUp) {
        this.checkOkUp = checkOkUp;
    }

    public String getCheckOkDown() {
        return checkOkDown;
    }

    public void setCheckOkDown(String checkOkDown) {
        this.checkOkDown = checkOkDown;
    }

    public Integer getPrecision() {
        return precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public Integer getOkScore() {
        return okScore;
    }

    public void setOkScore(Integer okScore) {
        this.okScore = okScore;
    }

    public Integer getNoScore() {
        return noScore;
    }

    public void setNoScore(Integer noScore) {
        this.noScore = noScore;
    }

    public String getCheckType() {
        return checkType;
    }

    public void setCheckType(String checkType) {
        this.checkType = checkType;
    }


    public String getBizOrgCode() {
        return bizOrgCode;
    }

    public void setBizOrgCode(String bizOrgCode) {
        this.bizOrgCode = bizOrgCode;
    }

    public String getBizOrgName() {
        return bizOrgName;
    }

    public void setBizOrgName(String bizOrgName) {
        this.bizOrgName = bizOrgName;
    }

    public String getEquipmentType() {
        return equipmentType;
    }

    public void setEquipmentType(String equipmentType) {
        this.equipmentType = equipmentType;
    }

    public String getFacilitiesType() {
        return facilitiesType;
    }

    public void setFacilitiesType(String facilitiesType) {
        this.facilitiesType = facilitiesType;
    }

    public String getKeyPartsType() {
        return keyPartsType.equals("是")?"0":"1";
    }

    public void setKeyPartsType(String keyPartsType) {
        this.keyPartsType = StringUtils.isEmpty(keyPartsType) ? "1":keyPartsType;
    }


    public String getCustomType() {
        return customType.equals("是")?"0":"1";
    }

    public void setCustomType(String customType) {
        this.customType = StringUtils.isEmpty(customType) ? "1":customType;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getCheckMethod() {
        return checkMethod;
    }

    public void setCheckMethod(String checkMethod) {
        this.checkMethod = checkMethod;
    }

    public String getInputClassify() {
        return inputClassify == null?null:PointCheckTypeEnum.getValue(inputClassify);
    }

    public void setInputClassify(String inputClassify) {
        this.inputClassify = inputClassify;
    }

    public String getItemNo() {
        return itemNo;
    }

    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    public String getLevel() {
        return  level == null? null :String.valueOf(PointLevelEnum.getValue(level));
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public long getCatalogId() {
        return catalogId;
    }

    public void setCatalogId(long catalogId) {
        this.catalogId = catalogId;
    }

    public String getDataJson() {
        return dataJson;
    }

    public void setDataJson(String dataJson) {
        this.dataJson = dataJson;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getInputJson() {
        return inputJson;
    }

    public void setInputJson(String inputJson) {
        this.inputJson = inputJson;
    }

    public String getIsMultiline() {
        return isMultiline;
    }

    public void setIsMultiline(String isMultiline) {
        this.isMultiline = isMultiline;
    }

    public String getIsMust() {
        return isMust;
    }

    public void setIsMust(String isMust) {
        this.isMust = isMust;
    }

    public String getIsScore() {
        return isScore;
    }

    public void setIsScore(String isScore) {
        this.isScore = isScore;
    }

    public String getItemType() {
        return itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(int orderNo) {
        this.orderNo = orderNo;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Object getPictureJson() {
        return pictureJson;
    }

    public void setPictureJson(Object pictureJson) {
        this.pictureJson = pictureJson;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public InputItemExcelDto() {
        super();
    }

    public String getRiskDesc() {
        return riskDesc;
    }

    public void setRiskDesc(String riskDesc) {
        this.riskDesc = riskDesc;
    }


}
