package com.yeejoin.amos.api.openapi.face.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDate;

/**
 * 气站卸液量记录表
 * @author tb
 *
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class TmCylinderOffloadingModel extends AbstractBaseModel {

	private static final long serialVersionUID = 1L;

	private String offloadingVolume;	//卸液量（单位吨）

	private String creditCode;	//对接单位统一信用代码

	protected String version = "v1"; //对接接口版本

	@ApiModelProperty(value = "统计同步时间 yyyy-MM-dd")
	private LocalDate statisticsSyncDate;
}
