package com.yeejoin.amos.api.openapi.face.service;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.api.openapi.constant.Constant;
import com.yeejoin.amos.api.openapi.face.model.BizTokenModel;
import com.yeejoin.amos.api.openapi.face.model.CylinderDateInfoModel;
import com.yeejoin.amos.api.openapi.face.model.CylinderTableModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.TmCylinderDateInfoMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;


/**
 * 
 * <pre>
 *气瓶基本信息 服务类
 * </pre>
 *
 * @author gwb
 * @version $Id: ElevatorService.java, v 0.1 2021年9月30日 下午3:28:55 gwb Exp $
 */
@Component
public class CylinderDateInfoService extends BaseService<CylinderDateInfoModel, CylinderDateInfo, TmCylinderDateInfoMapper> {
    @Autowired
    private RedisTemplate redisTemplate;
	@Autowired
	private TmCylinderUnitService cylinderUnitService;
	@Autowired
	private TmCylinderFillingCheckService cylinderFillingCheckService;
	@Autowired
	private TmCylinderFillingExamineService cylinderFillingExamineService;
	@Autowired
	private TmCylinderFillingRecordService cylinderFillingRecordService;
	@Autowired
	private TmCylinderFillingService cylinderFillingService;
	@Autowired
	private TmCylinderInfoService cylinderInfoService;
	@Autowired
	private TmCylinderInspectionService cylinderInspectionService;
	@Autowired
	private TmCylinderTagsService cylinderTagsService;
	@Autowired
	private OpenapiBizTokenService openapiBizTokenService;

	public final static long ONE_Minute =  60 * 1000 * 10;


	private String getAppId() {
		String tokenKey = Redis.genKey(Constant.TOKEN_PREFIX,RequestContext.getToken());
    	BizTokenModel bizTokenModel = (BizTokenModel) redisTemplate.opsForValue().get(tokenKey);
    	return bizTokenModel.getAppId();
	}

    public void updateTodayDate() {
		List<String> serviceUnitList = openapiBizTokenService.getServiceList();
		serviceUnitList.stream().forEach(s -> {
			List<OpenapiBizToken> tokenList = openapiBizTokenService.list(new LambdaQueryWrapper<OpenapiBizToken>().eq(OpenapiBizToken::getDeveloperAgency,s).eq(OpenapiBizToken::getDataType,"cyl"));
			for(OpenapiBizToken token : tokenList) {
				try {
					Date today = new Date();
					Calendar calendar = Calendar.getInstance();
					calendar.setTime(today);
					calendar.set(Calendar.SECOND,0);
					calendar.set(Calendar.HOUR_OF_DAY,0);
					calendar.set(Calendar.MINUTE,0);
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
					String todayStr = sdf.format(calendar.getTime());
					List<CylinderDateInfo> list = this.list(new LambdaQueryWrapper<CylinderDateInfo>().between(CylinderDateInfo::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59").eq(CylinderDateInfo::getAppId,token.getAppId()));
					if(list.size() == 0) {
						CylinderDateInfoModel temp = new CylinderDateInfoModel();
						temp.setSyncDate(calendar.getTime());
						String appid = token.getAppId();
						temp.setUnitName(token.getApiCompanyName());
						temp.setAppId(appid);
						temp.setDeveloperAgency(s);
						// 获取气瓶基本信息
						Integer cylinder = cylinderInfoService.count(new LambdaQueryWrapper<TmCylinderInfo>().eq(TmCylinderInfo::getAppId,appid).between(
								TmCylinderInfo::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
						Integer cylinderUnit = cylinderUnitService.count(new LambdaQueryWrapper<TmCylinderUnit>().eq(
								TmCylinderUnit::getAppId,appid).between(TmCylinderUnit::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
						Integer tags = cylinderTagsService.count(new LambdaQueryWrapper<TmCylinderTags>().eq(TmCylinderTags::getAppId,appid).between(
								TmCylinderTags::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
						Integer inspection = cylinderInspectionService.count(new LambdaQueryWrapper<TmCylinderInspection>().eq(
								TmCylinderInspection::getAppId,appid).between(TmCylinderInspection::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
						Integer filling = cylinderFillingService.count(new LambdaQueryWrapper<TmCylinderFilling>().eq(
                TmCylinderFilling::getAppId,appid).between(TmCylinderFilling::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
						Integer fillingRecord = cylinderFillingRecordService.count(new LambdaQueryWrapper<TmCylinderFillingRecord>().eq(
								TmCylinderFillingRecord::getAppId,appid).between(TmCylinderFillingRecord::getSyncDate,todayStr+ " 00:00:00",todayStr + " 23:59:59"));
						Integer fillingCheck = cylinderFillingCheckService.count(new LambdaQueryWrapper<TmCylinderFillingCheck>().eq(
								TmCylinderFillingCheck::getAppId,appid).between(TmCylinderFillingCheck::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
						Integer examine = cylinderFillingExamineService.count(new LambdaQueryWrapper<TmCylinderFillingExamine>().eq(
								TmCylinderFillingExamine::getAppId,appid).between(TmCylinderFillingExamine::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
						Integer total = cylinder + cylinderUnit + tags + inspection+filling+fillingRecord+fillingCheck+examine;
						temp.setCylinderExamineInfo(examine);
						temp.setCylinderUnit(cylinderUnit);
						temp.setCylinderFillingCheckInfo(fillingCheck);
						temp.setCylinderFillingInfo(filling);
						temp.setCylinderInspectionInfo(inspection);
						temp.setCylinderTagInfo(tags);
						temp.setCylinderInfo(cylinder);
						temp.setCylinderFillingRecordInfo(fillingRecord);
						temp.setCylinderTotal(total);
						this.createWithModel(temp);
					} else {
						list.forEach( info -> {
							String appid = token.getAppId();
							// 获取气瓶基本信息
							Integer cylinder = cylinderInfoService.count(new LambdaQueryWrapper<TmCylinderInfo>().eq(TmCylinderInfo::getAppId,appid).between(
									TmCylinderInfo::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
							Integer cylinderUnit = cylinderUnitService.count(new LambdaQueryWrapper<TmCylinderUnit>().eq(
									TmCylinderUnit::getAppId,appid).between(TmCylinderUnit::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
							Integer tags = cylinderTagsService.count(new LambdaQueryWrapper<TmCylinderTags>().eq(TmCylinderTags::getAppId,appid).between(
									TmCylinderTags::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
							Integer inspection = cylinderInspectionService.count(new LambdaQueryWrapper<TmCylinderInspection>().eq(
									TmCylinderInspection::getAppId,appid).between(TmCylinderInspection::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
							Integer filling = cylinderFillingService.count(new LambdaQueryWrapper<TmCylinderFilling>().eq(
                  TmCylinderFilling::getAppId,appid).between(TmCylinderFilling::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
							Integer fillingRecord = cylinderFillingRecordService.count(new LambdaQueryWrapper<TmCylinderFillingRecord>().eq(
									TmCylinderFillingRecord::getAppId,appid).between(TmCylinderFillingRecord::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
							Integer fillingCheck = cylinderFillingCheckService.count(new LambdaQueryWrapper<TmCylinderFillingCheck>().eq(
									TmCylinderFillingCheck::getAppId,appid).between(TmCylinderFillingCheck::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
							Integer examine = cylinderFillingExamineService.count(new LambdaQueryWrapper<TmCylinderFillingExamine>().eq(
									TmCylinderFillingExamine::getAppId,appid).between(TmCylinderFillingExamine::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
							Integer total = cylinder + cylinderUnit + tags + inspection+filling+fillingRecord+fillingCheck+examine;
							info.setCylinderExamineInfo(examine);
							info.setCylinderUnit(cylinderUnit);
							info.setCylinderFillingCheckInfo(fillingCheck);
							info.setCylinderFillingInfo(filling);
							info.setCylinderInspectionInfo(inspection);
							info.setCylinderTagInfo(tags);
							info.setCylinderInfo(cylinder);
							info.setCylinderFillingRecordInfo(fillingRecord);
							info.setCylinderTotal(total);
							this.updateById(info);
						});
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});

    }

	public List<CylinderTableModel> selectTodayDate(String serviceName, String appId, String startTime, String endTime) {
		List<CylinderTableModel> result = new ArrayList<>();
		List<String> serviceList = new ArrayList<>();
		// 如果没有serviceName 及 appId 获取全部数据
		if(StringUtils.isBlank(serviceName) && StringUtils.isBlank(appId) ) {
			serviceList = openapiBizTokenService.getServiceList();
		} else if(StringUtils.isNotBlank(serviceName) && StringUtils.isBlank(appId)) {
			serviceList = new ArrayList<String>();
			serviceList.add(serviceName);
		} else if(StringUtils.isNotBlank(appId)) { // 只查一个企业的

		}

		if(serviceList.size() > 0) {
			serviceList.stream().forEach(s -> {
				List<OpenapiBizToken> tokenList = openapiBizTokenService.list(new LambdaQueryWrapper<OpenapiBizToken>().eq(OpenapiBizToken::getDeveloperAgency,s).eq(OpenapiBizToken::getDataType,"cyl"));
				for(OpenapiBizToken token : tokenList) {
					CylinderTableModel temp = new CylinderTableModel();
					temp.setUnitName(token.getApiCompanyName());
					// 获取气瓶基本信息
					Integer cylinderUnit = 0;
					Integer cylinder = 0;
					Integer tags = 0;
					Integer inspection = 0;
					Integer flling = 0;
					Integer fllingRecord = 0;
					Integer fllingCheck = 0;
					Integer examine = 0;
					Integer total = 0;

					// 不传入时间默认全部数据
					if(StringUtils.isBlank(startTime) && StringUtils.isBlank(endTime)) {
						// 获取气瓶基本信息
						List<CylinderDateInfo> list = this.list(new LambdaQueryWrapper<CylinderDateInfo>().eq(CylinderDateInfo::getAppId,token.getAppId()));
						for(CylinderDateInfo info : list) {
							cylinder += info.getCylinderInfo();
							cylinderUnit += info.getCylinderUnit();
							tags += info.getCylinderTagInfo();
							inspection += info.getCylinderInspectionInfo();
							flling += info.getCylinderFillingInfo();
							fllingRecord += info.getCylinderFillingRecordInfo();
							fllingCheck += info.getCylinderFillingCheckInfo();
							examine += info.getCylinderExamineInfo();
							total += info.getCylinderTotal();
						}

					} else if(StringUtils.isNotBlank(startTime) && StringUtils.isBlank(endTime)) {
						// 获取气瓶基本信息
						List<CylinderDateInfo> list = this.list(new LambdaQueryWrapper<CylinderDateInfo>().eq(CylinderDateInfo::getAppId,token.getAppId()).ge(CylinderDateInfo::getSyncDate,startTime +" 00:00:00"));
						for(CylinderDateInfo info : list) {
							cylinder += info.getCylinderInfo();
							cylinderUnit += info.getCylinderUnit();
							tags += info.getCylinderTagInfo();
							inspection += info.getCylinderInspectionInfo();
							flling += info.getCylinderFillingInfo();
							fllingRecord += info.getCylinderFillingRecordInfo();
							fllingCheck += info.getCylinderFillingCheckInfo();
							examine += info.getCylinderExamineInfo();
							total += info.getCylinderTotal();
						}
					} else if(StringUtils.isBlank(startTime) && StringUtils.isNotBlank(endTime)) {
						// 获取气瓶基本信息
						List<CylinderDateInfo> list = this.list(new LambdaQueryWrapper<CylinderDateInfo>().eq(CylinderDateInfo::getAppId,token.getAppId()).le(CylinderDateInfo::getSyncDate,endTime +" 00:00:00"));
						for(CylinderDateInfo info : list) {
							cylinder += info.getCylinderInfo();
							cylinderUnit += info.getCylinderUnit();
							tags += info.getCylinderTagInfo();
							inspection += info.getCylinderInspectionInfo();
							flling += info.getCylinderFillingInfo();
							fllingRecord += info.getCylinderFillingRecordInfo();
							fllingCheck += info.getCylinderFillingCheckInfo();
							examine += info.getCylinderExamineInfo();
							total += info.getCylinderTotal();
						}
					} else if(StringUtils.isNotBlank(startTime) && StringUtils.isNotBlank(endTime)) {
						// 获取气瓶基本信息
						List<CylinderDateInfo> list = this.list(new LambdaQueryWrapper<CylinderDateInfo>().eq(CylinderDateInfo::getAppId,token.getAppId()).between(CylinderDateInfo::getSyncDate,startTime +" 00:00:00", endTime + " 23:59:59"));
						for(CylinderDateInfo info : list) {
							cylinder += info.getCylinderInfo();
							cylinderUnit += info.getCylinderUnit();
							tags += info.getCylinderTagInfo();
							inspection += info.getCylinderInspectionInfo();
							flling += info.getCylinderFillingInfo();
							fllingRecord += info.getCylinderFillingRecordInfo();
							fllingCheck += info.getCylinderFillingCheckInfo();
							examine += info.getCylinderExamineInfo();
							total += info.getCylinderTotal();
						}
					}

					temp.setCylinderUnit(cylinderUnit);
					temp.setCylinderFllingCheckInfo(fllingCheck);
					temp.setCylinderExamineInfo(examine);
					temp.setCylinderFllingInfo(flling);
					temp.setCylinderFllingRecordInfo(fllingRecord);
					temp.setCylinderInspectionInfo(inspection);
					temp.setCylinderTagInfo(tags);
					temp.setCylinderInfo(cylinder);
					temp.setCylinderTotal(total);
					result.add(temp);
				}
			});
		} else {
			OpenapiBizToken token = openapiBizTokenService.getOne(new LambdaQueryWrapper<OpenapiBizToken>().eq(OpenapiBizToken::getAppId,appId).eq(OpenapiBizToken::getDataType,"cyl"));
			CylinderTableModel temp = new CylinderTableModel();
			temp.setUnitName(token.getApiCompanyName());
			// 获取气瓶基本信息
			Integer cylinderUnit = 0;
			Integer cylinder = 0;
			Integer tags = 0;
			Integer inspection = 0;
			Integer flling = 0;
			Integer fllingRecord = 0;
			Integer fllingCheck = 0;
			Integer examine = 0;
			Integer total = 0;
			// 不传入时间默认全部数据
			if(StringUtils.isBlank(startTime) && StringUtils.isBlank(endTime)) {
				// 获取气瓶基本信息
				List<CylinderDateInfo> list = this.list(new LambdaQueryWrapper<CylinderDateInfo>().eq(CylinderDateInfo::getAppId,token.getAppId()));
				for(CylinderDateInfo info : list) {
					cylinder += info.getCylinderInfo();
					cylinderUnit += info.getCylinderUnit();
					tags += info.getCylinderTagInfo();
					inspection += info.getCylinderInspectionInfo();
					flling += info.getCylinderFillingInfo();
					fllingRecord += info.getCylinderFillingRecordInfo();
					fllingCheck += info.getCylinderFillingCheckInfo();
					examine += info.getCylinderExamineInfo();
					total += info.getCylinderTotal();
			}

			} else if(StringUtils.isNotBlank(startTime) && StringUtils.isBlank(endTime)) {
				// 获取气瓶基本信息
				List<CylinderDateInfo> list = this.list(new LambdaQueryWrapper<CylinderDateInfo>().eq(CylinderDateInfo::getAppId,token.getAppId()).ge(CylinderDateInfo::getSyncDate,startTime +" 00:00:00"));
				for(CylinderDateInfo info : list) {
					cylinder += info.getCylinderInfo();
					cylinderUnit += info.getCylinderUnit();
					tags += info.getCylinderTagInfo();
					inspection += info.getCylinderInspectionInfo();
					flling += info.getCylinderFillingInfo();
					fllingRecord += info.getCylinderFillingRecordInfo();
					fllingCheck += info.getCylinderFillingCheckInfo();
					examine += info.getCylinderExamineInfo();
					total += info.getCylinderTotal();
				}
			} else if(StringUtils.isBlank(startTime) && StringUtils.isNotBlank(endTime)) {
				// 获取气瓶基本信息
				List<CylinderDateInfo> list = this.list(new LambdaQueryWrapper<CylinderDateInfo>().eq(CylinderDateInfo::getAppId,token.getAppId()).le(CylinderDateInfo::getSyncDate,endTime +" 00:00:00"));
				for(CylinderDateInfo info : list) {
					cylinder += info.getCylinderInfo();
					cylinderUnit += info.getCylinderUnit();
					tags += info.getCylinderTagInfo();
					inspection += info.getCylinderInspectionInfo();
					flling += info.getCylinderFillingInfo();
					fllingRecord += info.getCylinderFillingRecordInfo();
					fllingCheck += info.getCylinderFillingCheckInfo();
					examine += info.getCylinderExamineInfo();
					total += info.getCylinderTotal();
				}
			} else if(StringUtils.isNotBlank(startTime) && StringUtils.isNotBlank(endTime)) {
				// 获取气瓶基本信息
				List<CylinderDateInfo> list = this.list(new LambdaQueryWrapper<CylinderDateInfo>().eq(CylinderDateInfo::getAppId,token.getAppId()).between(CylinderDateInfo::getSyncDate,startTime +" 00:00:00", endTime + " 23:59:59"));
				for(CylinderDateInfo info : list) {
					cylinder += info.getCylinderInfo();
					cylinderUnit += info.getCylinderUnit();
					tags += info.getCylinderTagInfo();
					inspection += info.getCylinderInspectionInfo();
					flling += info.getCylinderFillingInfo();
					fllingRecord += info.getCylinderFillingRecordInfo();
					fllingCheck += info.getCylinderFillingCheckInfo();
					examine += info.getCylinderExamineInfo();
					total += info.getCylinderTotal();
				}
			}

			temp.setCylinderUnit(cylinderUnit);
			temp.setCylinderFllingCheckInfo(fllingCheck);
			temp.setCylinderExamineInfo(examine);
			temp.setCylinderFllingInfo(flling);
			temp.setCylinderFllingRecordInfo(fllingRecord);
			temp.setCylinderInspectionInfo(inspection);
			temp.setCylinderTagInfo(tags);
			temp.setCylinderInfo(cylinder);
			temp.setCylinderTotal(total);
			result.add(temp);
		}
		return result;
	}

	public Boolean initCylinderNum() {
		//	气瓶企业信息、气瓶基本信息、气瓶标签信息、气瓶检验信息、气瓶充装前检查、气瓶充装信息、气瓶充装后复查、气瓶充装审核信息
		List<CylinderTableModel> result = new ArrayList<>();
		List<String> serviceList = openapiBizTokenService.getServiceList();
		List<String> dateList = cylinderFillingRecordService.getDateList();
		// 根据单位每一天 添加数据
		serviceList.stream().forEach(s -> {
			List<OpenapiBizToken> tokenList = openapiBizTokenService.list(new LambdaQueryWrapper<OpenapiBizToken>().eq(OpenapiBizToken::getDeveloperAgency,s).eq(OpenapiBizToken::getDataType,"cyl"));
			for(OpenapiBizToken token : tokenList) {
				for(String d : dateList) {
					CylinderDateInfoModel temp = new CylinderDateInfoModel();
					try {
						SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
						temp.setSyncDate(sdf.parse(d));
					} catch (ParseException e) {
						e.printStackTrace();
					}
					String appid = token.getAppId();
					temp.setUnitName(token.getApiCompanyName());
					temp.setAppId(appid);
					temp.setDeveloperAgency(s);
					// 获取气瓶基本信息
					Integer cylinder = cylinderInfoService.count(new LambdaQueryWrapper<TmCylinderInfo>().eq(TmCylinderInfo::getAppId,appid).between(
							TmCylinderInfo::getSyncDate,d + " 00:00:00",d + " 23:59:59"));
					Integer cylinderUnit = cylinderUnitService.count(new LambdaQueryWrapper<TmCylinderUnit>().eq(TmCylinderUnit::getAppId,appid).between(
							TmCylinderUnit::getSyncDate,d + " 00:00:00",d + " 23:59:59"));
					Integer tags = cylinderTagsService.count(new LambdaQueryWrapper<TmCylinderTags>().eq(TmCylinderTags::getAppId,appid).between(
							TmCylinderTags::getSyncDate,d + " 00:00:00",d + " 23:59:59"));
					Integer inspection = cylinderInspectionService.count(new LambdaQueryWrapper<TmCylinderInspection>().eq(
							TmCylinderInspection::getAppId,appid).between(TmCylinderInspection::getSyncDate,d + " 00:00:00",d + " 23:59:59"));
					Integer filling = cylinderFillingService.count(new LambdaQueryWrapper<TmCylinderFilling>().eq(
              TmCylinderFilling::getAppId,appid).between(TmCylinderFilling::getSyncDate,d + " 00:00:00",d + " 23:59:59"));
					Integer fillingRecord = cylinderFillingRecordService.count(new LambdaQueryWrapper<TmCylinderFillingRecord>().eq(
							TmCylinderFillingRecord::getAppId,appid).between(TmCylinderFillingRecord::getSyncDate,d + " 00:00:00",d + " 23:59:59"));
					Integer fillingCheck = cylinderFillingCheckService.count(new LambdaQueryWrapper<TmCylinderFillingCheck>().eq(
							TmCylinderFillingCheck::getAppId,appid).between(TmCylinderFillingCheck::getSyncDate,d + " 00:00:00",d + " 23:59:59"));
					Integer examine = cylinderFillingExamineService.count(new LambdaQueryWrapper<TmCylinderFillingExamine>().eq(
							TmCylinderFillingExamine::getAppId,appid).between(
							TmCylinderFillingExamine::getSyncDate,d + " 00:00:00",d + " 23:59:59"));
					Integer total = cylinder + cylinderUnit + tags + inspection+filling+fillingRecord+fillingCheck+examine;
					temp.setCylinderExamineInfo(examine);
					temp.setCylinderUnit(cylinderUnit);
					temp.setCylinderFillingCheckInfo(fillingCheck);
					temp.setCylinderFillingInfo(filling);
					temp.setCylinderInspectionInfo(inspection);
					temp.setCylinderTagInfo(tags);
					temp.setCylinderInfo(cylinder);
					temp.setCylinderFillingRecordInfo(fillingRecord);
					temp.setCylinderTotal(total);
					this.createWithModel(temp);
				}
			}
		});
		return true;
	}



//	@Scheduled(cron = "0 0 2 * * ?") //每天凌晨两点执行
	public void fixedDelayJob(){
		// 每天更新或者添加昨天的数据

		Date date = new Date();//取时间
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		calendar.add(Calendar.DATE,-1);
		//这个时间就是日期往后推一天的结果
		date=calendar.getTime();


		List<String> serviceUnitList = openapiBizTokenService.getServiceList();
		for(String s: serviceUnitList) {
			List<OpenapiBizToken> tokenList = openapiBizTokenService.list(new LambdaQueryWrapper<OpenapiBizToken>().eq(OpenapiBizToken::getDeveloperAgency,s).eq(OpenapiBizToken::getDataType,"cyl"));
			for(OpenapiBizToken token : tokenList) {
				try {
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
					String todayStr = sdf.format(date);
					List<CylinderDateInfo> list = this.list(new LambdaQueryWrapper<CylinderDateInfo>().between(CylinderDateInfo::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59").eq(CylinderDateInfo::getAppId,token.getAppId()));
					if(list.size() == 0) {
						CylinderDateInfoModel temp = new CylinderDateInfoModel();
						temp.setSyncDate(date);
						String appid = token.getAppId();
						temp.setUnitName(token.getApiCompanyName());
						temp.setAppId(appid);
						temp.setDeveloperAgency(s);
						// 获取气瓶基本信息
						Integer cylinder = cylinderInfoService.count(new LambdaQueryWrapper<TmCylinderInfo>().eq(TmCylinderInfo::getAppId,appid).between(
								TmCylinderInfo::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
						Integer cylinderUnit = cylinderUnitService.count(new LambdaQueryWrapper<TmCylinderUnit>().eq(
								TmCylinderUnit::getAppId,appid).between(TmCylinderUnit::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
						Integer tags = cylinderTagsService.count(new LambdaQueryWrapper<TmCylinderTags>().eq(TmCylinderTags::getAppId,appid).between(
								TmCylinderTags::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
						Integer inspection = cylinderInspectionService.count(new LambdaQueryWrapper<TmCylinderInspection>().eq(
								TmCylinderInspection::getAppId,appid).between(TmCylinderInspection::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
						Integer filling = cylinderFillingService.count(new LambdaQueryWrapper<TmCylinderFilling>().eq(
                TmCylinderFilling::getAppId,appid).between(TmCylinderFilling::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
						Integer fillingRecord = cylinderFillingRecordService.count(new LambdaQueryWrapper<TmCylinderFillingRecord>().eq(
								TmCylinderFillingRecord::getAppId,appid).between(TmCylinderFillingRecord::getSyncDate,todayStr+ " 00:00:00",todayStr + " 23:59:59"));
						Integer fillingCheck = cylinderFillingCheckService.count(new LambdaQueryWrapper<TmCylinderFillingCheck>().eq(
								TmCylinderFillingCheck::getAppId,appid).between(TmCylinderFillingCheck::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
						Integer examine = cylinderFillingExamineService.count(new LambdaQueryWrapper<TmCylinderFillingExamine>().eq(
								TmCylinderFillingExamine::getAppId,appid).between(TmCylinderFillingExamine::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
						Integer total = cylinder + cylinderUnit + tags + inspection+filling+fillingRecord+fillingCheck+examine;
						temp.setCylinderExamineInfo(examine);
						temp.setCylinderUnit(cylinderUnit);
						temp.setCylinderFillingCheckInfo(fillingCheck);
						temp.setCylinderFillingInfo(filling);
						temp.setCylinderInspectionInfo(inspection);
						temp.setCylinderTagInfo(tags);
						temp.setCylinderInfo(cylinder);
						temp.setCylinderFillingRecordInfo(fillingRecord);
						temp.setCylinderTotal(total);
						this.createWithModel(temp);
					} else {
						list.forEach( info -> {
							String appid = token.getAppId();
							// 获取气瓶基本信息
							Integer cylinder = cylinderInfoService.count(new LambdaQueryWrapper<TmCylinderInfo>().eq(TmCylinderInfo::getAppId,appid).between(
									TmCylinderInfo::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
							Integer cylinderUnit = cylinderUnitService.count(new LambdaQueryWrapper<TmCylinderUnit>().eq(
									TmCylinderUnit::getAppId,appid).between(TmCylinderUnit::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
							Integer tags = cylinderTagsService.count(new LambdaQueryWrapper<TmCylinderTags>().eq(TmCylinderTags::getAppId,appid).between(
									TmCylinderTags::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
							Integer inspection = cylinderInspectionService.count(new LambdaQueryWrapper<TmCylinderInspection>().eq(
									TmCylinderInspection::getAppId,appid).between(TmCylinderInspection::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
							Integer filling = cylinderFillingService.count(new LambdaQueryWrapper<TmCylinderFilling>().eq(
                  TmCylinderFilling::getAppId,appid).between(TmCylinderFilling::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
							Integer fillingRecord = cylinderFillingRecordService.count(new LambdaQueryWrapper<TmCylinderFillingRecord>().eq(
									TmCylinderFillingRecord::getAppId,appid).between(TmCylinderFillingRecord::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
							Integer fillingCheck = cylinderFillingCheckService.count(new LambdaQueryWrapper<TmCylinderFillingCheck>().eq(
									TmCylinderFillingCheck::getAppId,appid).between(TmCylinderFillingCheck::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
							Integer examine = cylinderFillingExamineService.count(new LambdaQueryWrapper<TmCylinderFillingExamine>().eq(
									TmCylinderFillingExamine::getAppId,appid).between(TmCylinderFillingExamine::getSyncDate,todayStr + " 00:00:00",todayStr + " 23:59:59"));
							Integer total = cylinder + cylinderUnit + tags + inspection+filling+fillingRecord+fillingCheck+examine;
							info.setCylinderExamineInfo(examine);
							info.setCylinderUnit(cylinderUnit);
							info.setCylinderFillingCheckInfo(fillingCheck);
							info.setCylinderFillingInfo(filling);
							info.setCylinderInspectionInfo(inspection);
							info.setCylinderTagInfo(tags);
							info.setCylinderInfo(cylinder);
							info.setCylinderFillingRecordInfo(fillingRecord);
							info.setCylinderTotal(total);
							this.updateById(info);
						});
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		};
		System.out.println("更新昨日数据成功");
	}


}
