package com.yeejoin.amos.boot.module.statistcs.biz.service.impl.ZBGLImpl;

import cn.hutool.core.lang.UUID;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import com.yeejoin.amos.boot.module.statistcs.biz.service.IZBGLService;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.StCommonServiceImpl;
import com.yeejoin.amos.boot.module.statistics.api.mapper.ZBGLStatisticsMapper;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

@Component
public class KrjyydqkServiceImpl implements IZBGLService {
    @Resource
    private StCommonServiceImpl stCommonService;

    @Resource
    private ZBGLStatisticsMapper zbglStatisticsMapper;
    @Override
    public Map<String, Object> getChart(DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        List<RegionModel> regionModels = stCommonService.setRegionIfRootParent(dpFilterParamForDetailDto.getCityCode());
        String time = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM"));
        List<Map<String,Object>> result =  regionModels.parallelStream().map(r -> {
            String orgCode = stCommonService.getAndSetOrgCode(r.getRegionCode()+"");
            DPFilterParamForDetailDto dpFilterParamForDetailDtoNew = new DPFilterParamForDetailDto();
            dpFilterParamForDetailDtoNew.setOrgCode(orgCode);
            Map<String, Object> itemResult = new HashMap<>();
            Map<String,Long> countMap = zbglStatisticsMapper.getKRJYYDQKChartData(dpFilterParamForDetailDtoNew,time);
            itemResult.put("count",countMap);
            itemResult.put("xdata",r.getRegionName());
            return itemResult;
        }).collect(Collectors.toList());

        Map<String,Object> returnMap = new HashMap<>();
        List<Map<String,Object>> legendData = new ArrayList<>();
        for(int i = 0;i<5; i++){
            Map<String,Object> map = new HashMap<>();
            if(i == 0){
                map.put("dataKey","lessNum");
                map.put("value","30分钟内到达次数");
                map.put("chartType","bar");
            }else if(i == 1) {
                map.put("dataKey", "greaterNum");
                map.put("value", "超过30分钟到次数");
                map.put("chartType","bar");
            }else if(i ==2){
                map.put("dataKey","levelOne");
                map.put("value","一级救援次数");
                map.put("chartType","bar");
            }else if(i == 3){
                map.put("dataKey","levelTwo");
                map.put("value","二级救援次数");
                map.put("chartType","bar");
            }else {
                map.put("dataKey","levelThree");
                map.put("value","三级救援次数");
                map.put("chartType","bar");
            }
            legendData.add(map);
        }
        returnMap.put("legendData",legendData);

        List xdata = new ArrayList();
        List lessNum = new ArrayList();
        List greaterNum = new ArrayList();
        List levelOne = new ArrayList();
        List levelTwo = new ArrayList();
        List levelThree = new ArrayList();

        for(int i = 0;i<result.size();i++){
            Map<String,Object> map = (Map<String, Object>) result.get(i).get("count");
            if(!CollectionUtils.isEmpty(map)) {
                lessNum.add(map.get("lessNum") == null ? "0" : map.get("lessNum") + "");
                greaterNum.add(map.get("greaterNum") == null ? "0" : map.get("greaterNum") + "");
                levelOne.add(map.get("levelOne") == null ? "0" : map.get("levelOne") + "");
                levelTwo.add(map.get("levelTwo") == null ? "0" : map.get("levelTwo") + "");
                levelThree.add(map.get("levelThree") == null ? "0" : map.get("levelThree") + "");
            }else{
                lessNum.add("0");
                greaterNum.add("0");
                levelOne.add("0");
                levelTwo.add("0");
                levelThree.add("0");
            }
            xdata.add(result.get(i).get("xdata"));

        }

        returnMap.put("xdata",xdata);
        returnMap.put("lessNum",lessNum);
        returnMap.put("greaterNum",greaterNum);
        returnMap.put("levelOne",levelOne);
        returnMap.put("levelTwo",levelTwo);
        returnMap.put("levelThree",levelThree);

        return returnMap;
    }

    @Override
    public Page<Map<String, Object>> getPage(Page page,DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        List<RegionModel> regionModels = stCommonService.setRegionIfRootParent(dpFilterParamForDetailDto.getCityCode());
        String time = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM"));
        List<Map<String,Object>> result =  regionModels.parallelStream().map(r -> {
            String orgCode = stCommonService.getAndSetOrgCode(r.getRegionCode()+"");
            DPFilterParamForDetailDto dpFilterParamForDetailDtoNew = new DPFilterParamForDetailDto();
            dpFilterParamForDetailDtoNew.setOrgCode(orgCode);
            Map<String, Object> itemResult = new HashMap<>();
            Map<String,Long> map = zbglStatisticsMapper.getKRJYYDQKChartData(dpFilterParamForDetailDtoNew,time);
            AtomicReference<Long> sum = new AtomicReference<>(0L);
            if(!CollectionUtils.isEmpty(map)) {
                map.entrySet().forEach(key -> {
                    sum.set(sum.get() + key.getValue());
                });
                map.entrySet().forEach(key -> {
                    if (sum.get() != 0 && key.getValue() != 0) {
                        itemResult.put(key.getKey(), key.getValue() + " / " + BigDecimal.valueOf(key.getValue()).divide(BigDecimal.valueOf(sum.get()), 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100)).stripTrailingZeros().toPlainString() + "%");
                    }
                });
            }
            itemResult.put("area",r.getRegionName());
            itemResult.put("sequenceNbr", UUID.fastUUID().toString());
            return itemResult;
        }).collect(Collectors.toList());
        page.setRecords(result);
        page.setTotal(result.size());
        return page;
    }

    @Override
    public List<Map<String, String>> getTitle(DPFilterParamForDetailDto dpFilterParamForDetailDto) {
        List<Map<String, String>> list = new ArrayList<>();
        for(int i = 0; i < 6; i++) {
            Map<String, String> map = new HashMap<>();
            if(i == 0) {
                map.put("dataIndex", "area");
                map.put("title", "区域");
            }else if(i == 1){
                map.put("dataIndex","lessNum");
                map.put("title","30分钟内到达次数");
            }else if(i == 2) {
                map.put("dataIndex", "greaterNum");
                map.put("title", "超过30分钟到次数");
            }else if(i ==3){
                map.put("dataIndex","levelOne");
                map.put("title","一级救援次数");
            }else if(i == 4){
                map.put("dataIndex","levelTwo");
                map.put("title","二级救援次数");
            }else {
                map.put("dataIndex","levelThree");
                map.put("title","三级救援次数");
            }
            list.add(map);
        }
        return list;
    }
}
