package com.yeejoin.amos.boot.module.tzs.flc.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 液化气体气瓶充装信息-充装记录
 *
 * @author system_generator
 * @date 2022-03-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="CylinderFillingRecordDto", description="液化气体气瓶充装信息-充装记录")
public class CylinderFillingRecordDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "充装记录Id")
    private String fillingRecordId;

    @ApiModelProperty(value = "充装企业名称")
    private String fillingUnitName;

    @ApiModelProperty(value = "出厂编号")
    private String factoryNum;

    @ApiModelProperty(value = "气瓶品种")
    private String cylinderVariety;

    @ApiModelProperty(value = "二维码编号")
    private String qrCode;

    @ApiModelProperty(value = "电子标签编号")
    private String electronicLabelCode;

    @ApiModelProperty(value = "气瓶唯一标识码")
    private String sequenceCode;

    @ApiModelProperty(value = "单位内部编号")
    private String unitInnerCode;

    @ApiModelProperty(value = "产权单位")
    private String propertyUnit;

    @ApiModelProperty(value = "充装开始时间")
    private String fillingStarttime;

    @ApiModelProperty(value = "充装结束时间")
    private String fillingEndtime;

    @ApiModelProperty(value = "充装人员姓名")
    private String fillingUser;

    @ApiModelProperty(value = "充装量（Kg）")
    private Double fillingQuantity;

    @ApiModelProperty(value = "室温")
    private Double temperature;

    @ApiModelProperty(value = "异常情况")
    private Integer abnormal;

    @ApiModelProperty(value = "异常情况")
    private String abnormalStr;


    @ApiModelProperty(value = "充装前检查时间")
    private String inspectionDate;

   @ApiModelProperty(value = "充装前检查结果")
   private String fillingResult;

    @ApiModelProperty(value = "充装前检查人员")
    private String inspectorUser;

    @ApiModelProperty(value = "充装后检查人员姓名")
    private String inspector;

    @ApiModelProperty(value = "充装后检查时间")
    private String inspectionDateAfter;

    @ApiModelProperty(value = "充装后检查结果")
    private String checkResult;


    @ApiModelProperty(value = "同步时间  yyyy-MM-dd HH24:mi:ss")
    private Date syncDate;

    @ApiModelProperty(value = "1初次同步数据   2上层系统已同步数据   0已删除数据")
    private Integer syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;

}
