package com.yeejoin.amos.boot.module.tzs.flc.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import java.util.List;

/**
 * 气瓶基本信息
 *
 * @author system_generator
 * @date 2021-12-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="CylinderInfoDto", description="气瓶基本信息")
public class CylinderInfoDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "气瓶基本信息ID")
    private String cylinderId;

    @ApiModelProperty(value = "产权单位名称")
    private String unitName;

    @ApiModelProperty(value = "出厂编号")
    private String factoryNum;

    @ApiModelProperty(value = "气瓶状态")
    private Integer cylinderStatus;

    @ApiModelProperty(value = "气瓶状态str")
    private String cylinderStatusStr;

    @ApiModelProperty(value = "气瓶品种")
    private Integer cylinderVariety;

    @ApiModelProperty(value = "气瓶品种str")
    private String cylinderVarietyStr;

    @ApiModelProperty(value = "二维码编号")
    private String qrCode;

    @ApiModelProperty(value = "电子标签编号")
    private String electronicLabelCode;

    @ApiModelProperty(value = "充装介质")
    private String fillingMedium;

    @ApiModelProperty(value = "公称压力(MPa）")
    private Double pressure;

    @ApiModelProperty(value = "容积（L）")
    private Double volume;

    @ApiModelProperty(value = "制造日期")
    private Date manufacturingDate;

    @ApiModelProperty(value = "制造单位")
    private String manufacturingUnit;

    @ApiModelProperty(value = "气瓶制造许可证")
    private String license;

    @ApiModelProperty(value = "气瓶重量（kg）")
    private Double cylinderWeight;

    @ApiModelProperty(value = "单位内部编号")
    private String unitInnerCode;

    @ApiModelProperty(value = "最近一次检验日期")
    private Date inspectionDate;

    @ApiModelProperty(value = "下次检验日期")
    private Date nextInspectionDate;

    @ApiModelProperty(value = "检验日期开始")
    private String inspectionDateStart;

    @ApiModelProperty(value = "检验日期结束")
    private String inspectionDateEnd;

    @ApiModelProperty(value = "气瓶唯一标识码")
    private String sequenceCode;

    @ApiModelProperty(value = "同步时间  yyyy-MM-dd HH24:mi:ss")
    private Date syncDate;

    @ApiModelProperty(value = "1初次同步数据   2上层系统已同步数据   0已删除数据")
    private Boolean syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;

    @ApiModelProperty(value = "所属区域代码")
    private String regionCode;

    @ApiModelProperty(value = "查询单位appid")
    private List<String> appIds;

}
