package com.yeejoin.amos.boot.module.tzs.flc.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 气瓶企业信息
 *
 * @author system_generator
 * @date 2021-12-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="CylinderUnitDto", description="气瓶企业信息")
public class CylinderUnitDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "单位ID")
    private String unitId;

    @ApiModelProperty(value = "所属区域")
    private String regionCode;

    @ApiModelProperty(value = "单位名称")
    private String unitName;

    @ApiModelProperty(value = "企业类型")
    private Integer unitType;

    @ApiModelProperty(value = "企业类型str")
    private String unitTypeStr;

    @ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;

    @ApiModelProperty(value = "详细地址")
    private String address;

    @ApiModelProperty(value = "企业负责人")
    private String unitPerson;

    @ApiModelProperty(value = "企业负责人手机")
    private String personMobilePhone;

    @ApiModelProperty(value = "企业负责人固定电话")
    private String personTelephone;

    @ApiModelProperty(value = "企业邮编")
    private String postalCode;

    @ApiModelProperty(value = "企业简称")
    private String unitAbbreviation;

    @ApiModelProperty(value = "充装许可证号")
    private String fillingLicense;

    @ApiModelProperty(value = "充装许可证有效期")
    private Date fillingPermitDate;

    @ApiModelProperty(value = "充装许可范围")
    private String fillingPermScope;

    @ApiModelProperty(value = "检验许可证号")
    private String inspectionLicense;

    @ApiModelProperty(value = "检验范围")
    private String inspectionScope;

    @ApiModelProperty(value = "检验许可证有效期")
    private Date effectiveDate;

    @ApiModelProperty(value = "制造许可证号")
    private String manufacturingLicense;

    @ApiModelProperty(value = "制造许可证有效期")
    private Date manufacturingDate;

    @ApiModelProperty(value = "制造许可范围")
    private String manufacturingScope;

    @ApiModelProperty(value = "制造单位代码")
    private String manufacturingUnitCode;

    @ApiModelProperty(value = "同步时间  yyyy-MM-dd HH24:mi:ss")
    private Date syncDate;

    @ApiModelProperty(value = "1初次同步数据   2上层系统已同步数据   0已删除数据")
    private Boolean syncState;

 @ApiModelProperty(value = "对接公司编码")
 private String appId;

   @ApiModelProperty(value = "气瓶数量")
   private Long cylinderNumber;

   @ApiModelProperty(value = "检验过期气瓶数量")
   private Long cylinderOutOfDate;


 @ApiModelProperty(value = "经度")
 private String longitude;

 @ApiModelProperty(value = "纬度")
 private String latitude;

 @ApiModelProperty(value = "是否过期")
 private Boolean outOfDate;

   @ApiModelProperty(value = "充装许可证有效期开始")
   private String fillingPermitDateStart;
   @ApiModelProperty(value = "充装许可证有效期结束")
   private String fillingPermitDateEnd;

}
