package com.yeejoin.amos.boot.module.tzs.flc.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 气瓶检验信息
 *
 * @author system_generator
 * @date 2022-03-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_cylinder_inspection")
public class CylinderInspection extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 检验信息ID
     */
	@TableField("inspection_id")
    private String inspectionId;

    /**
     * 检验单位
     */
	@TableField("inspection_unit")
    private String inspectionUnit;

    /**
     * 产权单位名称
     */
	@TableField("property_unit_name")
    private String propertyUnitName;

    /**
     * 出厂编号
     */
	@TableField("factory_num")
    private String factoryNum;

    /**
     * 气瓶唯一标识码
     */
	@TableField("sequence_code")
    private String sequenceCode;

    /**
     * 检验日期
     */
	@TableField("inspection_date")
    private String inspectionDate;

    /**
     * 下次检验日期
     */
	@TableField("next_inspection_date")
    private String nextInspectionDate;

    /**
     * 检验结果
     */
	@TableField("inspection_result")
    private String inspectionResult;

    /**
     * 同步时间  yyyy-MM-dd HH24:mi:ss
     */
	@TableField("sync_date")
    private Date syncDate;

    /**
     * 0-新增   1-更新  2-删除
     */
	@TableField("sync_state")
    private Integer syncState;

    /**
     * 对接公司编码
     */
	@TableField("app_id")
    private String appId;

    /**
     * 数据完整度
     */
    @TableField("integrity")
    private Double integrity;

}
