package com.yeejoin.amos.boot.module.tzs.flc.api.mapper;

import com.yeejoin.amos.boot.module.tzs.flc.api.entity.CylinderInfo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 气瓶基本信息 Mapper 接口
 *
 * @author system_generator
 * @date 2021-12-14
 */
public interface CylinderInfoMapper extends BaseMapper<CylinderInfo> {

    /**
     * 查询根据公司查询气瓶数量以及过期气瓶数
     * @param sequenceNbr
     * @return
     */
    Map<String, Long> queryNumAndOutOfDateNum(@Param("sequenceNbr")  Long sequenceNbr);

    /**
     * 获取上个月气瓶总量
     * @return
     */
    Integer getLastMonthInfoTotal(@Param("regionCode") String regionCode);

    /**
     * 获取上上个月气瓶总量
     * @return
     */
    Integer getMonthBeforeLastInfoTotal(@Param("regionCode")String regionCode);

    /**
     * 根据regionCode 获取气瓶数量
     * @param regionCode
     * @return
     */
    Integer getInfoTotalByRegionCode(@Param("regionCode") String regionCode);

    Double queryIntegirtyByAppId(@Param("appId")  String appId);

    Integer getWarnNum(String code);
}
