package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.dto.OrgUsrDto;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarmLog;
import com.yeejoin.equipmanage.common.entity.dto.AlarmDTO;
import com.yeejoin.equipmanage.common.entity.dto.EquipSpecificAlarmDTO;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentAppVO;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentBaseAppVO;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.mapper.EquipmentSpecificAlarmMapper;
import com.yeejoin.equipmanage.service.IEquipmentService;
import com.yeejoin.equipmanage.service.IEquipmentSpecificAlarmService;
import com.yeejoin.equipmanage.service.IEquipmentSpecificSerivceAlarm;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author ZeHua Li
 * @date 2020/10/29 14:26
 * @since v2.0
 */
@RestController
@Api(tags = "设备报警信息")
@RequestMapping(value = "/equipSpecificAlarm")
public class EquipmentSpecificAlarmController extends AbstractBaseController {

    @Autowired
    IEquipmentSpecificSerivceAlarm equipmentSpecificSerivceAlarm;
    @Autowired
    IEquipmentSpecificAlarmService iEquipmentSpecificAlarmService;
    @Autowired
    IEquipmentService iEquipmentService;
    @Autowired
    EquipmentSpecificAlarmMapper equipmentSpecificAlarmMapper;

    /**
     * 根据时间、或类型、或状态获取告警信息（参数非必填）
     * createDate：例："2020-12-24"或"1"（今天）或"7"（近7天）或"30"（近30天）
     * type：例：FIREALARM，默认（FIREALARM OR BREAKDOWN OR SHIELD）
     * status：1报警0恢复
     *
     * @param dto
     * @return
     */
    @RequestMapping(value = "/getEquipSpecificAlarmInfo", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据时间、或类型、或状态获取告警信息", notes = "根据时间、或类型、或状态获取告警信息")
    public Map<String, List<EquipSpecificAlarmDTO>> selectById(EquipSpecificAlarmDTO dto) {
        return equipmentSpecificSerivceAlarm.findByTypeAndDate(dto);
    }

    @RequestMapping(value = "/getEquipSpecificAlarmNotes", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取告警日志信息", notes = "获取告警日志信息")
    public ResponseModel selectListById(EquipSpecificAlarmDTO dto) {
        return CommonResponseUtil.success(equipmentSpecificSerivceAlarm.findListByTypeAndDate(dto));
    }

    @RequestMapping(value = "/lingZhou/getEquipSpecificAlarmNotes", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "数字换流站日志信息Top10", notes = "获取日志信息")
    public ResponseModel selectAlarmInfoById(EquipSpecificAlarmDTO dto) {
        return CommonResponseUtil.success(equipmentSpecificSerivceAlarm.findInfoByTypeAndDate(dto));
    }

    @RequestMapping(value = "/getCountAlarm", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "报警统计", notes = "报警统计")
    public ResponseModel<Map<String, Object>> getCountAlarm() {
        Map<String, Object> parmMap = new HashMap<String, Object>();
        parmMap.put("FIREALARM", 0);
        parmMap.put("BREAKDOWN", 0);
        parmMap.put("SHIELD", 0);
        parmMap.put("NOTICE", 0);
        List<Map<String, Object>> list = iEquipmentSpecificAlarmService.getCountAlarm();
        if (list != null && list.size() > 0) {
            list.forEach(listMap -> {
                parmMap.put((String) listMap.get("type"), listMap.get("num"));
            });
        }
        return CommonResponseUtil.success(parmMap);
    }



    @RequestMapping(value = "/getCountAlarm/{type}", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "报警统计", notes = "报警统计")
    public ResponseModel<Map<String, Object>> getcountAlarmtype(@PathVariable String type) {

        int num = iEquipmentSpecificAlarmService.getcountAlarmtype(type);

        return CommonResponseUtil.success(num);
    }

    @RequestMapping(value = "/getcountAlarmHandle/{type}", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "报警统计", notes = "报警统计")
    public ResponseModel<Map<String, Object>> getcountAlarmHandle(@PathVariable String type) {

        int num = iEquipmentSpecificAlarmService.getcountAlarmHandle(type);

        return CommonResponseUtil.success(num);
    }




    @RequestMapping(value = "/getCountEquipment", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "设备统计", notes = "设备统计")
    public ResponseModel getCountEquipment() {
        Map<String, Object> parmMap = new HashMap<String, Object>();
        int total = iEquipmentSpecificAlarmService.getCountEquipment();
        int abnormal = iEquipmentSpecificAlarmService.getCountAlarmEquipment();
        parmMap.put("total", total);
        parmMap.put("normal", total - abnormal);
        parmMap.put("abnormal", abnormal);
        return CommonResponseUtil.success(parmMap);
    }

    @RequestMapping(value = "/getAlarmPage", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "警情分页查询", notes = "警情分页查询")
    public ResponseModel getAlarmPage(int pageNum, int pageSize, AlarmDTO dto) {
        dto.setStatus("1");
        Page page = new Page(pageNum, pageSize);
        Page<EquipSpecificAlarmDTO> pageBean = iEquipmentSpecificAlarmService.getAlarmPage(page, dto);
        return CommonResponseUtil.success(pageBean);
    }


    @RequestMapping(value = "/getEqPage", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "装备分页查询", notes = "装备分页查询")
    public ResponseModel getEqPage(int pageNum, int pageSize, AlarmDTO dto) {
        Page page = new Page<>(pageNum, pageSize);
        if ("全部".equals(dto.getWarehouseStructureName())){
        dto.setWarehouseStructureName(null);
        }
        if ("all".equals(dto.getStatus())){
            dto.setStatus(null);
        }
        Page<EquipSpecificAlarmDTO> pageBean = iEquipmentSpecificAlarmService.getEqPage(page, dto);
        return CommonResponseUtil.success(pageBean);
    }

    @RequestMapping(value = "/getConfirmUser", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取处理人", notes = "获取处理人")
    public ResponseModel<List<EquipmentSpecificAlarmLog>> getConfirmUser() {

        return  CommonResponseUtil.success(iEquipmentSpecificAlarmService.getConfirmUser());

    }
    
    /**
     * 设备信息
     *
     * @return
     */
    @GetMapping(value = "/getdetail")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取设备详情", notes = "获取设备详情")
    public ResponseModel<EquipmentAppVO> detail(String qrCode) {
        EquipmentAppVO equipmentAppVO = iEquipmentService.getEquipmentAppMessage(qrCode);
        EquipmentBaseAppVO equipmentBase = equipmentAppVO.getEquipmentBase();
        if (equipmentBase != null) {
            EquipSpecificAlarmDTO equipSpecificAlarmDTO = equipmentSpecificAlarmMapper.getbyqrCode(qrCode);
            if (equipSpecificAlarmDTO != null) {
                equipmentBase.setAlarmTime(equipSpecificAlarmDTO.getCreateDate());
                equipmentBase.setAlarmType(equipSpecificAlarmDTO.getType());
            }

            equipmentAppVO.setEquipmentBase(equipmentBase);
        }
        return CommonResponseUtil.success(equipmentAppVO);
    }

}






