package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.beanutils.ConvertUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Sequence;
import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.biz.common.utils.QRCodeUtil;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.common.api.dto.CompanyPerson;
import com.yeejoin.amos.boot.module.common.api.dto.DutyCarDto;
import com.yeejoin.amos.boot.module.common.api.dto.DutyFireFightingDto;
import com.yeejoin.amos.boot.module.common.api.dto.DutyFirstAidDto;
import com.yeejoin.amos.boot.module.common.api.dto.DutyPersonDto;
import com.yeejoin.amos.boot.module.common.api.dto.DutyPersonShiftDto;
import com.yeejoin.amos.boot.module.common.api.dto.DutyShiftDto;
import com.yeejoin.amos.boot.module.common.api.dto.DynamicFormInitDto;
import com.yeejoin.amos.boot.module.common.api.dto.DynamicFormInstanceDto;
import com.yeejoin.amos.boot.module.common.api.dto.ExcelDto;
import com.yeejoin.amos.boot.module.common.api.dto.FireChemicalDto;
import com.yeejoin.amos.boot.module.common.api.dto.FireExpertsDto;
import com.yeejoin.amos.boot.module.common.api.dto.FireStationDto;
import com.yeejoin.amos.boot.module.common.api.dto.FireTeamDto;
import com.yeejoin.amos.boot.module.common.api.dto.FirefightersDto;
import com.yeejoin.amos.boot.module.common.api.dto.FirefightersExcelDto;
import com.yeejoin.amos.boot.module.common.api.dto.FirefightersInfoDto;
import com.yeejoin.amos.boot.module.common.api.dto.KeySiteExcleDto;
import com.yeejoin.amos.boot.module.common.api.dto.LinkageUnitDto;
import com.yeejoin.amos.boot.module.common.api.dto.LinkageUnitVo;
import com.yeejoin.amos.boot.module.common.api.dto.MaintenancePersonExcleDto;
import com.yeejoin.amos.boot.module.common.api.dto.OrgUsrDto;
import com.yeejoin.amos.boot.module.common.api.dto.OrgUsrExcelDto;
import com.yeejoin.amos.boot.module.common.api.dto.OrgUsrFormDto;
import com.yeejoin.amos.boot.module.common.api.dto.RescueEquipmentDto;
import com.yeejoin.amos.boot.module.common.api.dto.SpecialPositionStaffDto;
import com.yeejoin.amos.boot.module.common.api.dto.WaterResourceDto;
import com.yeejoin.amos.boot.module.common.api.entity.DynamicFormColumn;
import com.yeejoin.amos.boot.module.common.api.entity.DynamicFormInstance;
import com.yeejoin.amos.boot.module.common.api.entity.FireChemical;
import com.yeejoin.amos.boot.module.common.api.entity.FireExperts;
import com.yeejoin.amos.boot.module.common.api.entity.FireStation;
import com.yeejoin.amos.boot.module.common.api.entity.FireTeam;
import com.yeejoin.amos.boot.module.common.api.entity.Firefighters;
import com.yeejoin.amos.boot.module.common.api.entity.FirefightersContacts;
import com.yeejoin.amos.boot.module.common.api.entity.FirefightersEducation;
import com.yeejoin.amos.boot.module.common.api.entity.FirefightersPost;
import com.yeejoin.amos.boot.module.common.api.entity.FirefightersWorkexperience;
import com.yeejoin.amos.boot.module.common.api.entity.MaintenanceCompany;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.common.api.entity.RescueEquipment;
import com.yeejoin.amos.boot.module.common.api.entity.SpecialPositionStaff;
import com.yeejoin.amos.boot.module.common.api.excel.ExcelUtil;
import com.yeejoin.amos.boot.module.common.api.service.IDutyFireFightingService;
import com.yeejoin.amos.boot.module.common.api.service.IDutyFirstAidService;
import com.yeejoin.amos.boot.module.common.api.service.IDutyPersonService;
import com.yeejoin.amos.boot.module.common.api.service.IKeySiteService;
import com.yeejoin.amos.boot.module.common.api.service.IMaintenanceCompanyService;
import com.yeejoin.amos.boot.module.common.api.service.IOrgUsrService;
import com.yeejoin.amos.boot.module.common.biz.service.impl.DutyCarServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.DutyPersonServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.DutyPersonShiftServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.DutyShiftServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.DynamicFormColumnServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.DynamicFormInstanceServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FireChemicalServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FireExpertsServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FireStationServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FireTeamServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FirefightersContactsServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FirefightersEducationServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FirefightersPostServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FirefightersServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FirefightersWorkexperienceServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.LinkageUnitServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.OrgUsrServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.RescueEquipmentServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.SpecialPositionStaffServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.WaterResourceServiceImpl;
import com.yeejoin.amos.boot.module.jcs.api.dto.AircraftDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.OrgUsrSafeReportExcelDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.Aircraft;
import com.yeejoin.amos.boot.module.jcs.api.entity.OrgUsrSafeReport;
import com.yeejoin.amos.boot.module.jcs.api.enums.ExcelEnums;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;

/**
 * @author tb
 */
@Service
public class ExcelServiceImpl {

	private static final String NOT_DUTY = "休班";
	private static final String PERSON = "PERSON";
	private static final String MAINTENANCE_PERSON = "maintenancePerson";

	@Autowired
	DataSourcesImpl dataSourcesImpl;
	@Autowired
	FireChemicalServiceImpl fireChemicalServiceImpl;
	@Autowired
	FireExpertsServiceImpl fireExpertsServiceImpl;
	@Autowired
	WaterResourceServiceImpl waterResourceServiceImpl;
	@Autowired
	AircraftServiceImpl aircraftServiceImpl;
	@Autowired
	FireTeamServiceImpl fireTeamService;
	@Autowired
	FireStationServiceImpl fireStationService;
	@Autowired
	FirefightersServiceImpl firefightersService;
	@Autowired
	IMaintenanceCompanyService maintenanceCompanyService;
	@Autowired
	IKeySiteService keySiteService;
	@Autowired
	DutyCarServiceImpl dutyCarService;
	@Autowired
	DutyPersonServiceImpl dutyPersonService;
	@Autowired
	Sequence sequence;
	@Autowired
	DynamicFormColumnServiceImpl dynamicFormColumnService;
	@Autowired
	DutyPersonShiftServiceImpl dutyPersonShiftService;
	@Autowired
	OrgUsrServiceImpl orgUsrService;
	@Autowired
	DutyShiftServiceImpl dutyShiftService;
	@Autowired
	IDutyPersonService iDutyPersonService;
	@Autowired
	DynamicFormColumnServiceImpl dynamicFormColumnServiceImpl;
	@Autowired
	LinkageUnitServiceImpl linkageUnitServiceImpl;
	@Autowired
	SpecialPositionStaffServiceImpl specialPositionStaffServiceImpl;
	@Autowired
	RescueEquipmentServiceImpl rescueEquipmentServiceImpl;
	@Autowired
	IOrgUsrService orgUsrServer;
	@Autowired
	DataDictionaryServiceImpl iDataDictionaryService;

	@Autowired
	FirefightersPostServiceImpl iFirefightersPostService;
	@Autowired
	FirefightersContactsServiceImpl ifirefightersContactsService;
	@Autowired
	FirefightersEducationServiceImpl ifirefightersEducationService;
	@Autowired
	FirefightersWorkexperienceServiceImpl ifirefightersWorkexperienceService;

	@Autowired
	IDutyFireFightingService dutyFireFightingService;

	@Autowired
	OrgUsrSafeReportServiceImpl orgUsrSafeReportService;

	@Autowired
	IDutyFirstAidService dutyFirstAidService;

	@Autowired
	DynamicFormInstanceServiceImpl dynamicFormInstanceService;
	
	public void templateExport(HttpServletResponse response, ExcelDto excelDto) throws ClassNotFoundException {
		String url = excelDto.getClassUrl();
		Class<?> clz = Class.forName(url);
		ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), null, clz, dataSourcesImpl,
				true);
	}

	public void commonExport(HttpServletResponse response, ExcelDto excelDto, Map par) {
		
//		ReginParams  reginParams=	getCurrentAllInfo();
//		 boolean authFalg= false;
//		if(reginParams ==null) {
//			authFalg=true;
//		}
//        String bizOrgCode = reginParams.getPersonIdentity().getBizOrgCode();
//		if(org.apache.commons.lang3.StringUtils.isBlank(bizOrgCode)){
//			authFalg=true;
//		}
        //效验参数
		boolean authFalg=getFlag(par);

		switch (excelDto.getType()) {

		case "WHP":
			List<FireChemicalDto> data = null;
			if(par.size()>0) {
				data = fireChemicalServiceImpl.queryForFireChemicalList(par.containsKey("casNo")?par.get("casNo").toString():null,par.containsKey("formula")?par.get("formula").toString():null,
						par.containsKey("name")?par.get("name").toString():null,par.containsKey("typeCode")?par.get("typeCode").toString():null,false);
			}else{
				data = fireChemicalServiceImpl.queryForFireChemicalList(null,null,null,null,false);
			}
			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), data,
					FireChemicalDto.class, dataSourcesImpl, false);
			break;
		case "XFZJ":
			List<FireExpertsDto> fireExpertsDtoList =null;
			if(par.size()>0) {
			  fireExpertsDtoList = fireExpertsServiceImpl.queryForFireExpertsList(false,par.containsKey("name")?par.get("name").toString():null,par.containsKey("expertCode")?par.get("expertCode").toString():null);
			}else{
				  fireExpertsDtoList = fireExpertsServiceImpl.queryForFireExpertsList(false,null,null);
			}
			QueryWrapper<DataDictionary> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("type", "XLLX");
			List<DataDictionary> list = iDataDictionaryService.list(queryWrapper);
			for (FireExpertsDto fireExpertsDto : fireExpertsDtoList) {
				for (DataDictionary dataDictionary : list) {
					if (fireExpertsDto.getHighestEducation() != null
							&& !fireExpertsDto.getHighestEducation().equals("")) {
						if (fireExpertsDto.getHighestEducation().equals(dataDictionary.getCode())) {
							fireExpertsDto.setHighestEducation(dataDictionary.getName());
						}
					}
				}
			}
			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), fireExpertsDtoList,
					FireExpertsDto.class, dataSourcesImpl, false);
			break;
		case "SYXX":
			if(!authFalg) {
				ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), null,
						WaterResourceDto.class, dataSourcesImpl, false);
				break;
			}
			List<WaterResourceDto> waterResourceDtoList = null;
			if(par.size()>0) {
				waterResourceDtoList = waterResourceServiceImpl.exportToExcel(true,par.containsKey("name")?par.get("name").toString():null,
						par.containsKey("resourceType")?par.get("resourceType").toString():null,par.containsKey("bizOrgCode")?par.get("bizOrgCode").toString():null);
			}else{
				waterResourceDtoList = waterResourceServiceImpl.exportToExcel(true,null,null,par.containsKey("bizOrgCode")?par.get("bizOrgCode").toString():null);
			}
			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), waterResourceDtoList,
					WaterResourceDto.class, dataSourcesImpl, false);
			break;
		case "HKQ":
			List<AircraftDto> aircraftDtoList = null;
			if(par.size()>0) {
				aircraftDtoList = aircraftServiceImpl.queryAircraftDtoForList(false,par.containsKey("aircraftModel")?par.get("aircraftModel").toString():null,
						par.containsKey("engineTypeCode")?par.get("engineTypeCode").toString():null,par.containsKey("fuelTypeCode")?par.get("fuelTypeCode").toString():null);
			}else{
				aircraftDtoList = aircraftServiceImpl.queryAircraftDtoForList(false,null,null,null);
			}
			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), aircraftDtoList,
					AircraftDto.class, dataSourcesImpl, false);
			break;
		case "XFDW":



			if(!authFalg) {
				ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), null,
						FireTeamDto.class, dataSourcesImpl, false);
				break;
			}
			List<FireTeamDto> fireTeamDtoList = fireTeamService.queryFireTeamForList(false, par);
			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), fireTeamDtoList,
					FireTeamDto.class, dataSourcesImpl, false);
			break;
		case "WXXFZ":
			if(!authFalg) {
				ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), null,
						FireStationDto.class, null, false);
				break;
			}
            String nameString =null;
            Long bizCompanyId =null; 
			if(par!=null && par.size()>0) {
				nameString =par.containsKey("name")?par.get("name").toString():null;
				bizCompanyId =par.containsKey("bizCompanyId")?Long.parseLong(par.get("bizCompanyId").toString()):null;
			}
			List<FireStationDto> fireStationDtoList = fireStationService.queryForFireStationList(false, bizCompanyId,nameString,par.containsKey("bizOrgCode")?par.get("bizOrgCode").toString():null);
			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), fireStationDtoList,
					FireStationDto.class, null, false);
			break;
		case "XFRY":
			if(!authFalg) {
				ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(),
						null, FirefightersExcelDto.class, null, false);
				break;
			}
			List<FirefightersExcelDto> firefightersExcelDtoList = firefightersService.exportToExcel(false, par);
			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(),
					firefightersExcelDtoList, FirefightersExcelDto.class, null, false);
			break;
		case "WBRY":
			List<MaintenancePersonExcleDto> maintenancePersonExcelDtoList = maintenanceCompanyService
					.exportToMaintenancePersonExcel(par);
			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(),
					maintenancePersonExcelDtoList, MaintenancePersonExcleDto.class, null, false);
			break;
		case "KEYSITE":
			if(!authFalg) {
				ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), null,
						KeySiteExcleDto.class, null, false);
				break;
			}
			List<KeySiteExcleDto> keySiteDtoList = null;
			if(par.size()>0 && par.containsKey("bizOrgCode")&&!par.get("bizOrgCode").equals("undefined")) {
				keySiteDtoList = keySiteService.exportToExcel(par.containsKey("name")?par.get("name").toString():null,
						par.containsKey("buildingId")?Long.valueOf(par.get("buildingId").toString()):null,
						par.containsKey("fireEnduranceRate")?par.get("fireEnduranceRate").toString():null,
						par.containsKey("useNature")?par.get("useNature").toString():null,
						par.containsKey("fireFacilitiesInfo")?par.get("fireFacilitiesInfo").toString():null,
						par.containsKey("bizOrgCode")? par.get("bizOrgCode").toString():null);
			}else{
				keySiteDtoList = keySiteService.exportToExcel(null,null,null,null,null,null);
			}
			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), keySiteDtoList,
					KeySiteExcleDto.class, null, false);
			break;
		case "JCDWRY":
			if(!authFalg) {
				ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), null,
						OrgUsrExcelDto.class, null, false);
				break;
			}
			List<OrgUsrExcelDto> orgUsrList = orgUsrService.exportToExcel(par);
			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), orgUsrList,
					OrgUsrExcelDto.class, null, false);
			break;
		case "LDDW":
			List<LinkageUnitDto> LinkageUnitDtoList = null;
			String inAgreement = par.containsKey("inAgreement")&&!(par.get("inAgreement").toString()).equals("null")?par.get("inAgreement").toString():"";

			if(par.size()>0) {
				LinkageUnitDtoList = linkageUnitServiceImpl.exportToExcel(par.containsKey("unitName")?par.get("unitName").toString():null,
						par.containsKey("linkageUnitTypeCode")?par.get("linkageUnitTypeCode").toString():null,
						par.containsKey("emergencyLinkageUnitCode")?par.get("emergencyLinkageUnitCode").toString():null
						);
			}else{
				LinkageUnitDtoList = linkageUnitServiceImpl.exportToExcel(null,null,null);
			}

			List<Map> linkageUnitListMap =JSONArray.parseArray(JSONArray.toJSONString(LinkageUnitDtoList), Map.class);

			List<Map<String, Object>> pageList = dynamicFormInstanceService.listAll("linkageUnit");


			linkageUnitListMap.forEach(i -> {
				if ( i.get("instanceId") != null){
					String mainString = i.get("instanceId").toString();
					pageList.stream().forEach(detail -> {
						if (detail.get("instanceId").toString().equals(mainString)) {
							i.putAll(detail);
						}
					});
				}
			});
			List<LinkageUnitDto> resultDtoList = JSONArray.parseArray(JSONArray.toJSONString(linkageUnitListMap),
					LinkageUnitDto.class);
			List<LinkageUnitDto> detaiList = resultDtoList.stream().map(item -> {
				Date now = new Date();
				if (item.getLongitude() != null){

				}
				boolean isInAgreement = DateUtils.belongCalendar(now, item.getAgreementStartDate(),
						item.getAgreementEndDate());
				item.setInAgreement(isInAgreement ? "是" : "否");
				return item;
			}).filter(item -> org.apache.commons.lang3.StringUtils.isEmpty(inAgreement) || inAgreement.equals(item.getInAgreement()))
					.collect(Collectors.toList());
			/*经纬度导出精度会丢失 转换成string导出 2021-11-02 陈召 开始*/
			List<LinkageUnitVo> result = new ArrayList<>();
			detaiList.forEach(d->{
				LinkageUnitVo linkageUnitVo = new LinkageUnitVo();
				BeanUtils.copyProperties(d,linkageUnitVo);
				linkageUnitVo.setLatitude(d.getLatitude() != null? String.valueOf(d.getLatitude()):" ");
				linkageUnitVo.setLongitude(d.getLongitude() != null?String.valueOf(d.getLongitude()):" ");
				result.add(linkageUnitVo);
			});
			/*经纬度导出精度会丢失 转换成string导出 2021-11-02 陈召 结束*/
			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), result,
					LinkageUnitVo.class, null, false);
			break;
		default:
			break;
		}
	}

	@Transactional
	public void commonUpload(MultipartFile multipartFile, ExcelDto excelDto,String uuidString) throws Exception {
		switch (excelDto.getType()) {

		case "WHP":
			excelImportFireChemical(multipartFile);
			break;
		case "XFZJ":
			excelImportFireExperts(multipartFile);
			break;
		case "SYXX":
			excelImportWaterResource(multipartFile);
			break;
		case "HKQ":
			excelImportAircraft(multipartFile);
			break;
		case "XFDW":
			excelImportFireTeam(multipartFile);
			break;
		case "WXXFZ":
			excelImportFireStation(multipartFile);
			break;
		case "XFRY":
			excelImportFirefighters(multipartFile);
			break;
		case "CLZQ":
			excelImportDutyPerson(multipartFile, "CLZQ",uuidString);
			break;
		case "RYZB":
			excelImportDutyPerson(multipartFile, "RYZB",uuidString);
			break;
		case "WBRY":
			excelImportMaintenancePerson(multipartFile);
			break;
		case "KEYSITE":
			excelImportKeySite(multipartFile);
			break;
		case "JCDWRY":
			excelImportOrgUsrExcelDto(multipartFile);
			break;
		case "LDDW":
			excelImportLinkageUnitZhDto(multipartFile);
			break;
		// BUG 2455 相关代码 bykongfm
		case "TGRY":
			excelImportLinkageUnitTGRYDto(multipartFile);
			break;
		case "JYZB":
			excelImportLinkageUnitJYZBDto(multipartFile);
			break;
		case "WXXFZB":
			excelImportDutyPerson(multipartFile, "WXXFZB",uuidString);
			break;
		case "XFAQBG":
			excelImportSafeReport(multipartFile);
			break;
		case "JJZB":
			excelImportDutyPerson(multipartFile, "JJZB",uuidString);
			break;
		}
		return;
	}

	private void excelImportLinkageUnitTGRYDto(MultipartFile multipartFile) throws Exception {

		List<SpecialPositionStaffDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile,
				SpecialPositionStaffDto.class, 1);

		if (excelDtoList != null && excelDtoList.size() > 0) {
			outer: for (SpecialPositionStaffDto positionStaffDto : excelDtoList) {
				String code = "";
				if (positionStaffDto.getPositionName() != null) {
					String[] certificates = positionStaffDto.getPositionName().split("@");
					positionStaffDto.setPositionName(certificates[0]);
					positionStaffDto.setPositionNameCode(certificates[1]);
					code = certificates[1];
				} else {
					continue;
				}
				if (positionStaffDto.getCompany() != null) {
					String[] certificates = positionStaffDto.getCompany().split("@");
					positionStaffDto.setCompany(certificates[0]);
					positionStaffDto.setCompanyId(Long.parseLong(certificates[1]));
					// 获取特岗人员已经存在的岗位 如果存在则不导入
					LambdaQueryWrapper<SpecialPositionStaff> queryWrapper = new LambdaQueryWrapper<>();
					queryWrapper.eq(SpecialPositionStaff::getCompanyId, Long.parseLong(certificates[1]))
							.eq(SpecialPositionStaff::getIsDelete, false);
					List<SpecialPositionStaff> tempList = specialPositionStaffServiceImpl.list(queryWrapper);
					for (SpecialPositionStaff temp : tempList) {
						if (temp.getPositionNameCode().equals(code)) {
							continue outer; // 已经存在则不导入继续循环
						}
					}
				} else {
					continue;
				}
				positionStaffDto = Bean.toPo(getCurrentInfo(), positionStaffDto);
				specialPositionStaffServiceImpl.createWithModel(positionStaffDto);
			}
		}
	}

	private void excelImportLinkageUnitJYZBDto(MultipartFile multipartFile) throws Exception {
		List<RescueEquipmentDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile, RescueEquipmentDto.class,
				1);
		if (excelDtoList != null && excelDtoList.size() > 0) {
			outer: for (RescueEquipmentDto rescueEquipmentDto : excelDtoList) {
				String code = "";
				if (rescueEquipmentDto.getVehicleType() != null) {
					String[] certificates = rescueEquipmentDto.getVehicleType().split("@");
					rescueEquipmentDto.setVehicleType(certificates[0]);
					rescueEquipmentDto.setVehicleTypeCode(certificates[1]);
					code = certificates[1];
				} else {
					continue;
				}
				if (rescueEquipmentDto.getCompany() != null) {
					String[] certificates = rescueEquipmentDto.getCompany().split("@");
					rescueEquipmentDto.setCompany(certificates[0]);
					rescueEquipmentDto.setCompanyId(Long.parseLong(certificates[1]));
					// 获取救援装备已经存在的装备 如果存在则不导入
					LambdaQueryWrapper<RescueEquipment> queryWrapper = new LambdaQueryWrapper<>();
					queryWrapper.eq(RescueEquipment::getCompanyId, Long.parseLong(certificates[1]))
							.eq(RescueEquipment::getIsDelete, false);
					List<RescueEquipment> tempList = rescueEquipmentServiceImpl.list(queryWrapper);
					for (RescueEquipment temp : tempList) {
						if (temp.getVehicleTypeCode().equals(code)) {
							continue outer; // 已经存在则不导入继续循环
						}
					}
				} else {
					continue;
				}
				rescueEquipmentDto = Bean.toPo(getCurrentInfo(), rescueEquipmentDto);
				rescueEquipmentServiceImpl.createWithModel(rescueEquipmentDto);
			}

		}
	}

	private void excelImportLinkageUnitZhDto(MultipartFile multipartFile) throws Exception {
		List<LinkageUnitDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile, LinkageUnitDto.class, 1);

		if (excelDtoList != null && excelDtoList.size() > 0) {
			excelDtoList.forEach(linkageUnitDto -> {
				if (linkageUnitDto.getLinkageUnitType() != null) {
					String[] certificates = linkageUnitDto.getLinkageUnitType().split("@");
					linkageUnitDto.setLinkageUnitType(certificates[0]);
					linkageUnitDto.setLinkageUnitTypeCode(certificates[1]);
				}
				if (linkageUnitDto.getEmergencyLinkageUnit() != null) {
					String[] certificates = linkageUnitDto.getEmergencyLinkageUnit().split("@");
					linkageUnitDto.setEmergencyLinkageUnit(certificates[0]);
					linkageUnitDto.setEmergencyLinkageUnitCode(certificates[1]);
				}
				linkageUnitDto = Bean.toPo(getCurrentInfo(), linkageUnitDto);
				linkageUnitServiceImpl.saveLinkageModel(linkageUnitDto);
			});
		}

	}

	private void excelImportOrgUsrExcelDto(MultipartFile multipartFile) throws Exception {

		List<OrgUsrExcelDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile, OrgUsrExcelDto.class, 1);

		if (excelDtoList != null && excelDtoList.size() > 0) {
			excelDtoList.forEach(orgUsrExcelDto -> {
				if (orgUsrExcelDto.getParentId() != null) {
					String[] certificates = orgUsrExcelDto.getParentId().split("@");
					orgUsrExcelDto.setParentId(certificates[1]);
				}
				// 动态字段填充

				List<DynamicFormInitDto> dynamicFormColumn = dynamicFormColumnServiceImpl.getFormlist("246");

				List<DynamicFormInstanceDto> dynamicFormValue = new ArrayList<>();
				List<DynamicFormInstance> dynamicFormInstancelist = new ArrayList<>();

				dynamicFormColumn.forEach(DynamicFormInitDto -> {
					dynamicFormValue.add(DynamicFormInitDto.getFormItemDescr());
				});

				dynamicFormValue.forEach(dynamicFormInstanceDto -> {
					switch (dynamicFormInstanceDto.getFieldCode()) {
					case "administrativePositionCode":
						if (orgUsrExcelDto.getAdministrativePositionCode() != null) {
							String[] certificates = orgUsrExcelDto.getAdministrativePositionCode().split("@");
							dynamicFormInstanceDto.setFieldValue(certificates[1]);
							dynamicFormInstanceDto.setFieldValueLabel(certificates[0]);
						}
						break;
					case "auditCycle":
						if (orgUsrExcelDto.getAuditCycle() != null) {
							String[] certificates = orgUsrExcelDto.getAuditCycle().split("@");
							dynamicFormInstanceDto.setFieldValue(certificates[1]);
							dynamicFormInstanceDto.setFieldValueLabel(certificates[0]);

						}
						break;
					case "certificatesNumber":
						dynamicFormInstanceDto.setFieldValue(orgUsrExcelDto.getCertificatesNumber());
						break;
					case "certificatesTypeCode":
						if (orgUsrExcelDto.getCertificatesTypeCode() != null) {
							String[] certificates = orgUsrExcelDto.getCertificatesTypeCode().split("@");
							dynamicFormInstanceDto.setFieldValue(certificates[1]);
							dynamicFormInstanceDto.setFieldValueLabel(certificates[0]);

						}
						break;
					case "certificateType": // 持证类别
						if (orgUsrExcelDto.getCertificateType() != null) {
							String[] certificates = orgUsrExcelDto.getCertificateType().split("@");
							dynamicFormInstanceDto.setFieldValue(certificates[1]);
							dynamicFormInstanceDto.setFieldValueLabel(certificates[0]);
						}
						break; // BUG 2892 导入机场单位没有持证类别和 人员性别 处理 by kongfm 2021-09-16
					case "fireManagementPostCode":
						if (orgUsrExcelDto.getFireManagementPostCode() != null) {
							String[] certificates = orgUsrExcelDto.getFireManagementPostCode().split("@");
							dynamicFormInstanceDto.setFieldValue(certificates[1]);
							dynamicFormInstanceDto.setFieldValueLabel(certificates[0]);
						}
						break;
					case "gender":
						if (orgUsrExcelDto.getGender() != null) {// BUG 2892 导入机场单位没有持证类别和 人员性别 处理 by kongfm 2021-09-16
							String[] gender = orgUsrExcelDto.getGender().split("@");
							dynamicFormInstanceDto.setFieldValue(gender[1]);
							dynamicFormInstanceDto.setFieldValueLabel(gender[0]);
						}
						break;
					case "internalPositionCode":
						if (orgUsrExcelDto.getInternalPositionCode() != null) {
							String[] certificates = orgUsrExcelDto.getInternalPositionCode().split("@");
							dynamicFormInstanceDto.setFieldValue(certificates[1]);
							dynamicFormInstanceDto.setFieldValueLabel(certificates[0]);

						}
						break;
					case "personNumber":
						dynamicFormInstanceDto.setFieldValue(orgUsrExcelDto.getPersonNumber());
						break;
					case "positionType":
						if (orgUsrExcelDto.getPositionType() != null) {
							String[] certificates = orgUsrExcelDto.getPositionType().split("@");
							dynamicFormInstanceDto.setFieldValue(certificates[1]);
							dynamicFormInstanceDto.setFieldValueLabel(certificates[0]);

						}
						break;
					case "safetyTraining":
						if (orgUsrExcelDto.getSafetyTraining() != null) {
							String[] certificates = orgUsrExcelDto.getSafetyTraining().split("@");
							dynamicFormInstanceDto.setFieldValue(certificates[1]);
							dynamicFormInstanceDto.setFieldValueLabel(certificates[0]);

						}
						break;
					case "stateCode":
						if (orgUsrExcelDto.getStateCode() != null) {
							String[] certificates = orgUsrExcelDto.getStateCode().split("@");
							dynamicFormInstanceDto.setFieldValue(certificates[1]);
							dynamicFormInstanceDto.setFieldValueLabel(certificates[0]);

						}
						break;
					case "telephone":
						dynamicFormInstanceDto.setFieldValue(orgUsrExcelDto.getTelephone());
						break;

					}

					DynamicFormInstance dynamicFormInstance = new DynamicFormInstance();
					BeanUtils.copyProperties(dynamicFormInstanceDto, dynamicFormInstance);
					dynamicFormInstancelist.add(dynamicFormInstance);

				});
				orgUsrExcelDto.setDynamicFormValue(dynamicFormInstancelist);
				Bean.toPo(getCurrentInfo(), orgUsrExcelDto);
				try {
					orgUsrService.saveOrgPersonExcel(orgUsrExcelDto);
				} catch (Exception e) {
					throw new RuntimeException("导入失败!");
				}
			});
		}

	}

	private void excelImportFirefighters(MultipartFile multipartFile) throws Exception {
		List<FirefightersExcelDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile,
				FirefightersExcelDto.class, 1);
		excelDtoList.forEach(item -> {
			Firefighters firefighters = new Firefighters();
			FirefightersContacts firefightersContacts = new FirefightersContacts();
			firefighters = Bean.toPo(item, firefighters);
			firefighters = Bean.toPo(getCurrentInfo(), firefighters);
			// 手动添加主键，以便于给岗位、职位等实体赋值id
			Long sequenceId = sequence.nextId();
			firefighters.setSequenceNbr(sequenceId);
			item.setFirefightersId(sequenceId);
			firefightersContacts = Bean.toPo(item, firefightersContacts);

			FirefightersWorkexperience firefightersWorkexperience = new FirefightersWorkexperience();
			FirefightersEducation firefightersEducation = new FirefightersEducation();
			FirefightersPost firefightersPost = new FirefightersPost();

			firefightersWorkexperience = Bean.toPo(item, firefightersWorkexperience);
			firefightersEducation = Bean.toPo(item, firefightersEducation);
			firefightersPost = Bean.toPo(item, firefightersPost);

			if (item.getFireTeam() != null) {
				Long fireTeamId = Long.valueOf(item.getFireTeam().split("@")[1]);
				firefighters.setFireTeamId(fireTeamId);
				firefighters.setFireTeamName(item.getFireTeam().split("@")[0]);
			}
			if (firefighters.getCertificatesType() != null) {
				String[] certificates = firefighters.getCertificatesType().split("@");
				firefighters.setCertificatesType(certificates[0]);
				firefighters.setCertificatesTypeCode(certificates[1]);
			}
			if (firefighters.getState() != null) {
				String[] state = firefighters.getState().split("@");
				firefighters.setState(state[0]);
				firefighters.setStateCode(state[1]);
			}
			if (firefighters.getJobTitle() != null) {
				String[] jobTitle = firefighters.getJobTitle().split("@");
				firefighters.setJobTitle(jobTitle[0]);
				firefighters.setJobTitleCode(jobTitle[1]);
			}
			if (firefightersContacts.getRelationship() != null) {
				String relationship = firefightersContacts.getRelationship().split("@")[1];
				firefightersContacts.setRelationship(relationship);
			}
			if (firefighters.getCompanyName() != null) {
				String[] tempCompany = firefighters.getCompanyName().split("@");
				firefighters.setCompanyName(tempCompany[0]);
				firefighters.setCompanyCode(tempCompany[1]);
				firefighters.setCompany(tempCompany[1]);
				OrgUsr result = orgUsrService.getById(Long.valueOf(tempCompany[1]));
				firefighters.setBizOrgName(tempCompany[0]);
				firefighters.setBizOrgCode(result.getBizOrgCode());
			}
			if (firefighters.getNativePlaceValue() != null) {
				String[] tempCity = firefighters.getNativePlaceValue().split("@");
				firefighters.setNativePlaceValue(tempCity[0]);
				firefighters.setNativePlace(tempCity[1]);
			}
			if (firefighters.getResidence() != null) {
				String[] tempCity = firefighters.getResidence().split("@");
				firefighters.setResidence(tempCity[0]);
				firefighters.setResidenceDetails(tempCity[1]);
			}
			/************************* 岗位职级 ***********************/
			if (item.getEmployeeHierarchy() != null) {
				String[] employeeHierarchy = item.getEmployeeHierarchy().split("@");
				firefightersPost.setEmployeeHierarchy(employeeHierarchy[0]);
				firefightersPost.setEmployeeHierarchyCode(employeeHierarchy[1]);
			}
			if (item.getAdministrativePosition() != null) {
				String[] employeeHierarchy = item.getAdministrativePosition().split("@");
				firefightersPost.setAdministrativePosition(employeeHierarchy[0]);
				firefightersPost.setAdministrativePositionCode(employeeHierarchy[1]);
			}
			if (item.getEmployeeHierarchy() != null) {
				String[] employeeHierarchy = item.getEmployeeHierarchy().split("@");
				firefightersPost.setEmployeeHierarchy(employeeHierarchy[0]);
				firefightersPost.setEmployeeHierarchyCode(employeeHierarchy[1]);
			}
			if (item.getPostQualification() != null) {
				String[] employeeHierarchy = item.getPostQualification().split("@");
				firefightersPost.setPostQualification(employeeHierarchy[0]);
				firefightersPost.setPostQualificationCode(employeeHierarchy[1]);
			}
			if (item.getCategory() != null) {
				String[] employeeHierarchy = item.getCategory().split("@");
				firefightersPost.setCategory(employeeHierarchy[0]);
				firefightersPost.setCategoryCode(employeeHierarchy[1]);
			}
			if (item.getLevel() != null) {
				String[] employeeHierarchy = item.getLevel().split("@");
				firefightersPost.setLevel(employeeHierarchy[0]);
				firefightersPost.setLevelCode(employeeHierarchy[1]);
			}
			if (item.getAreasExpertise() != null) {
				String[] employeeHierarchy = item.getAreasExpertise().split("@");
				firefightersPost.setAreasExpertise(employeeHierarchy[0]);
				firefightersPost.setAreasExpertiseCode(employeeHierarchy[1]);
			}

			/************************* 学历教育 ***********************/
			if (item.getFirstDegree() != null) {
				String[] employeeHierarchy = item.getFirstDegree().split("@");
				firefightersEducation.setFirstDegree(employeeHierarchy[1]);
			}

			if (item.getHighestEducation() != null) {
				String[] employeeHierarchy = item.getHighestEducation().split("@");
				firefightersEducation.setHighestEducation(employeeHierarchy[1]);
			}
			if (item.getAcademicDegree() != null) {
				String[] employeeHierarchy = item.getAcademicDegree().split("@");
				firefightersEducation.setAcademicDegree(employeeHierarchy[1]);
			}

			iFirefightersPostService.save(firefightersPost);
			ifirefightersEducationService.save(firefightersEducation);
			ifirefightersWorkexperienceService.save(firefightersWorkexperience);
			// BUG 2760 修改消防人员导出模板和 导入问题 bykongfm
			FirefightersInfoDto firefightersInfo = new FirefightersInfoDto(firefighters, firefightersContacts);
			firefightersService.saveFirefighters(firefightersInfo);
		});
	}

	private void excelImportFireStation(MultipartFile multipartFile) throws Exception {
		
		List<FireStationDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile, FireStationDto.class, 1);
		Map<String, String> maps =	getAllBuildingIdForParentBuilingIds(excelDtoList);
		List<FireStation> excelEntityList = new ArrayList<>();
		excelDtoList.forEach(item -> {
			FireStation fireStation = new FireStation();
			fireStation = Bean.toPo(item, fireStation);
			fireStation = Bean.toPo(getCurrentInfo(), fireStation);
			if (fireStation.getWhereBuilding() != null) {
				String[] whereBuilding = fireStation.getWhereBuilding().split("@");
				fireStation.setWhereBuilding(whereBuilding[0]);
				fireStation.setWhereBuildingId(whereBuilding[1]);
				if(maps.containsKey(whereBuilding[1])){
					fireStation.setParentBuildingId(maps.get(whereBuilding[1]));
				}
			}
			if (fireStation.getBizCompany() != null) {
				String[] bizCompany = fireStation.getBizCompany().split("@");
				fireStation.setBizCompany(bizCompany[0]);
				fireStation.setBizOrgName(bizCompany[0]);
				fireStation.setBizCompanyId(Long.valueOf(bizCompany[1]));
				OrgUsr byId = orgUsrService.getById(Long.valueOf(bizCompany[1]));
				if (byId != null && byId.getBizOrgCode() != null){
					fireStation.setBizCompanyCode(byId.getBizOrgCode());
					fireStation.setBizOrgCode(byId.getBizOrgCode());
				}
			}
			if (fireStation.getPersonChargeName() != null){
				String[] personChargeName = fireStation.getPersonChargeName().split("@");
				fireStation.setPersonChargeName(personChargeName[0]);
				fireStation.setPersonChargeId(personChargeName[1]);
			}
			excelEntityList.add(fireStation);
		});
		fireStationService.saveBatch(excelEntityList);
	}
	   public Map<String, String> getAllBuildingIdForParentBuilingIds(List<FireStationDto> excelDtoList) {
	    	List<String> list = new ArrayList<String>();
	    	for (FireStationDto fireStation : excelDtoList) {
				if (org.apache.commons.lang3.StringUtils.isNotBlank(fireStation.getWhereBuilding())) {
					String[] whereBuilding = fireStation.getWhereBuilding().split("@");
					fireStation.setWhereBuildingId(whereBuilding[1]);
					list.add(whereBuilding[1]);
				}
			}
			return keySiteService.getNodeAllParentIds(list);
	    }
	private void excelImportFireTeam(MultipartFile multipartFile) throws Exception {
		List<FireTeamDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile, FireTeamDto.class, 1);
		List<FireTeam> excelEntityList = new ArrayList<>();

		excelDtoList.forEach(item -> {
			FireTeam fireTeam = new FireTeam();
			fireTeam = Bean.toPo(item, fireTeam);
			fireTeam = Bean.toPo(getCurrentInfo(), fireTeam);
			/* bug2835 添加获取上级单位的信息方法 陈浩 2021-09-10 --start */
			if (fireTeam.getCompanyName() != null) {
				String[] companyArray = fireTeam.getCompanyName().split("@");
				fireTeam.setCompany(Long.parseLong(companyArray[1]));
				fireTeam.setCompanyName(companyArray[0]);
				try {
					OrgUsrFormDto companyDto = orgUsrServer.selectCompanyById(Long.parseLong(companyArray[1]));
					fireTeam.setCompanyCode(companyDto.getBizOrgCode());
					fireTeam.setBizOrgCode(companyDto.getBizOrgCode());
					fireTeam.setBizOrgName(companyDto.getBizOrgName());
					} catch (Exception e) {

				}
			}
			/* bug2835 添加获取上级单位的信息方法 陈浩 2021-09-10 --end */
			if (fireTeam.getType() != null) {
				String[] type = fireTeam.getType().split("@");
				fireTeam.setType(type[0]);
				fireTeam.setTypeCode(type[1]);
			}
			if (fireTeam.getContactUser() != null) {
				String[] contactUser = fireTeam.getContactUser().split("@");
				fireTeam.setContactUser(contactUser[0]);
				fireTeam.setContactUserId(Long.valueOf(contactUser[1]));
			}
			if (item.getParentName() != null) {
				String[] parentName = item.getParentName().split("@");
				fireTeam.setParent(Long.valueOf(parentName[1]));
			}
			excelEntityList.add(fireTeam);
		});
		fireTeamService.saveBatch(excelEntityList);
	}

	private void excelImportAircraft(MultipartFile multipartFile) throws Exception {
		List<AircraftDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile, AircraftDto.class, 1);
		List<Aircraft> excelEntityList = new ArrayList<>();
		excelDtoList.forEach(item -> {
			Aircraft aircraft = new Aircraft();
			aircraft = Bean.toPo(item, aircraft);
			aircraft = Bean.toPo(getCurrentInfo(), aircraft);
			if (aircraft.getEngineType() != null) {
				String[] engineType = aircraft.getEngineType().split("@");
				aircraft.setEngineType(engineType[0]);
				aircraft.setEngineTypeCode(engineType[1]);
			}
			if (aircraft.getFuelType() != null) {
				String[] fuelType = aircraft.getFuelType().split("@");
				aircraft.setFuelType(fuelType[0]);
				aircraft.setFuelTypeCode(fuelType[1]);
			}
			excelEntityList.add(aircraft);
		});
		aircraftServiceImpl.saveBatch(excelEntityList);
	}

	private void excelImportFireChemical(MultipartFile multipartFile) throws Exception {
		List<FireChemicalDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile, FireChemicalDto.class, 1);
		List<FireChemical> excelEntityList = new ArrayList<>();
		excelDtoList.forEach(item -> {
			FireChemical fireChemical = new FireChemical();
			fireChemical = Bean.toPo(item, fireChemical);
			fireChemical = Bean.toPo(getCurrentInfo(), fireChemical);
			if (fireChemical.getType() != null) {
				String[] type = fireChemical.getType().split("@");
				fireChemical.setType(type[0]);
				fireChemical.setTypeCode(type[1]);
			}
			excelEntityList.add(fireChemical);
		});
		fireChemicalServiceImpl.saveBatch(excelEntityList);
	}

	private void excelImportWaterResource(MultipartFile multipartFile) throws Exception {
		List<WaterResourceDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile, WaterResourceDto.class, 1);

		excelDtoList.forEach(item -> {
			/* Bug 2950 消防水源，缺失设施分类、设施定义等必填字段可以上传成功 陈召 2021-10-09 */
			if (item.getEquipName() == null || item.getEquipName().equals(" ")) {
				throw new RuntimeException("设备定义名称为必填字段，填写后重新上传");
			}

			// BUG 2953 导入模板没有设备编码生成 2021-09-18 陈召开始
			item.setEquipCode(QRCodeUtil.generateQRCode());
			// BUG 2953 导入模板没有设备编码生成 2021-09-18 陈召结束
			if (item.getResourceTypeName() != null) {
				String[] resourceTypeName = item.getResourceTypeName().split("@");
				item.setResourceTypeName(resourceTypeName[0]);
				item.setResourceType(resourceTypeName[1]);
			}
			if (item.getHydrantType() != null) {
				item.setType(item.getHydrantType());
			}
			if (item.getSystemType() != null) {
				String[] systemType = item.getSystemType().split("@");
				item.setSystemType(systemType[0]);
				item.setSystemTypeCode(systemType[1]);
			}
			if (item.getPlaceForm() != null) {
				String[] placeForm = item.getPlaceForm().split("@");
				item.setPlaceForm(placeForm[0]);
				item.setPlaceFormCode(placeForm[1]);
			}
			if (item.getBelongBuilding() != null) {
				String[] belongBuilding = item.getBelongBuilding().split("@");
				item.setBelongBuilding(belongBuilding[0]);
				item.setBelongBuildingId(Long.valueOf(belongBuilding[1]));
			}
			if (item.getBelongFightingSystem() != null) {
				String[] belongFightingSystem = item.getBelongFightingSystem().split("@");
				item.setBelongFightingSystem(belongFightingSystem[0]);
				item.setBelongFightingSystemId(Long.valueOf(belongFightingSystem[1]));
			}
			if (item.getManagementUnit() != null) {
				String[] managementUnit = item.getManagementUnit().split("@");
				item.setManagementUnit(managementUnit[0]);
				item.setManagementUnitId(Long.valueOf(managementUnit[1]));
				OrgUsr org = orgUsrService.getById(Long.valueOf(managementUnit[1]));
				if(org!=null) {
					item.setBizOrgCode(org.getBizOrgCode());
					item.setBizOrgName(org.getBizOrgName());
				}
			}
			if (item.getMaintenanceUnit() != null) {
				String[] maintenanceUnit = item.getMaintenanceUnit().split("@");
				item.setMaintenanceUnit(maintenanceUnit[0]);
				item.setMaintenanceUnitId(Long.valueOf(maintenanceUnit[1]));
			}
			if (item.getHoseConnection() != null) {
				String[] hoseConnection = item.getHoseConnection().split("@");
				item.setHoseConnection(hoseConnection[0]);
				item.setHoseConnectionCode(hoseConnection[1]);
			}
			if (item.getIntakeForm() != null) {
				String[] intakeForm = item.getIntakeForm().split("@");
				item.setIntakeForm(intakeForm[0]);
			}
			if (item.getPipeTypeName() != null) {
				String[] pipeTypeName = item.getPipeTypeName().split("@");
				item.setPipeTypeName(pipeTypeName[0]);
				item.setPipeTypeCode(pipeTypeName[1]);
			}
			if (item.getStatus() != null) {
				String[] status = item.getStatus().split("@");
				item.setStatus(status[0]);
				item.setStatusCode(status[1]);
			}
			if (item.getType() != null) {
				String[] type = item.getType().split("@");
				item.setType(type[0]);
				item.setTypeCode(type[1]);
			}
			// BUG 2935 优化项 分类从93060000 取得字典数据 by kongfm 2021-09-17
			if (item.getEquipCategoryName() != null) {
				String[] equipCategory = item.getEquipCategoryName().split("@");
				item.setEquipCategoryName(equipCategory[0]);
				item.setEquipCategoryId(Long.parseLong(equipCategory[1]));
			}

			if (item.getHasDrySeasonType() != null) {
				boolean flag = "有".equals(item.getHasDrySeasonType()) ? true : false;
				item.setHasDrySeason(flag);
			}
			if (item.getEquipName() != null) {
				String[] equipCategory = item.getEquipName().split("@");
				item.setEquipId(Long.parseLong(equipCategory[1]));
				item.setEquipName(equipCategory[0]);
				item.setEquipCategoryId(Long.parseLong(equipCategory[2]));
				item.setEquipCategoryName(equipCategory[3]);
				switch (equipCategory[3]) {
				case "天然水源":
					item.setEquipCategoryCode("93060300");
					break;
				case "水源-消火栓":
					item.setEquipCategoryCode("93060400");
					break;
				case "消火栓":
					item.setEquipCategoryCode("93060400");
					break;
				case "消防水池":
					item.setEquipCategoryCode("93060100");
					break;
				case "消防水鹤":
					item.setEquipCategoryCode("93060200");
					break;
				default:
					break;
				}
			}
			if (item.getContactUser() != null) {
				String[] contactUser = item.getContactUser().split("@");
				item.setContactUser(contactUser[0]);
				item.setContactUserId(contactUser[1]);
			}
			item = Bean.toPo(getCurrentInfo(), item);
			//水源的isdelete是反着的
			item.setIsDelete(true);
			waterResourceServiceImpl.importByExcel(item);
		});
	}

	private void excelImportFireExperts(MultipartFile multipartFile) throws Exception {
		List<FireExpertsDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile, FireExpertsDto.class, 1);
		List<FireExperts> excelEntityList = new ArrayList<>();
		excelDtoList.forEach(fireExpertsDto -> {
			FireExperts fireExperts = new FireExperts();
			fireExperts = Bean.toPo(fireExpertsDto, fireExperts);
			fireExperts = Bean.toPo(getCurrentInfo(), fireExperts);
			if (fireExperts.getCertificatesType() != null) {
				String[] certificates = fireExperts.getCertificatesType().split("@");
				fireExperts.setCertificatesType(certificates[0]);
				fireExperts.setCertificatesTypeCode(certificates[1]);
			}
			if (fireExperts.getJobs() != null) {
				String[] jobs = fireExperts.getJobs().split("@");
				fireExperts.setJobs(jobs[0]);
				fireExperts.setJobsCode(jobs[1]);
			}
			if (fireExperts.getExpert() != null) {
				String[] expert = fireExperts.getExpert().split("@");
				fireExperts.setExpert(expert[0]);
				fireExperts.setExpertCode(expert[1]);
			}
			if (fireExperts.getHighestEducation() != null) {
				String[] highestEducation = fireExperts.getHighestEducation().split("@");
				fireExperts.setHighestEducation(highestEducation[1]); // BUG 2942 by litw 2021年9月18日 导入学历编号
			}
			if (fireExperts.getNativePlaceVal() != null) {
				String[] nativePlaceVal = fireExperts.getNativePlaceVal().split("@");
				fireExperts.setNativePlace(nativePlaceVal[1]);
				fireExperts.setNativePlaceVal(nativePlaceVal[0]);
			}
			if (fireExperts.getResidenceDetailVal() != null) {
				String[] residenceDetailVal = fireExperts.getResidenceDetailVal().split("@");
				fireExperts.setResidence(residenceDetailVal[1]);
				fireExperts.setResidenceDetailVal(residenceDetailVal[0]);
			}
			excelEntityList.add(fireExperts);
		});
		fireExpertsServiceImpl.saveBatch(excelEntityList);
	}
    @Async
	private void excelImportDutyPerson(MultipartFile multipartFile, String dutyType,String uuidString) throws Exception {
		try {
			ImportDutyPerson(multipartFile,dutyType);
			if(redisUtils.hasKey(uuidString)){
				redisUtils.set(uuidString, 1);
			}
		} catch (Exception e) {
			if(redisUtils.hasKey(uuidString)){
				redisUtils.set(uuidString, 2);
			}
		}
		
	}
    private void ImportDutyPerson(MultipartFile multipartFile, String dutyType) throws Exception {
    	String fileName = multipartFile.getOriginalFilename();
		if (fileName == null) {
			throw new Exception("文件不存在！");
		}
		if (!fileName.toLowerCase().endsWith(ExcelTypeEnum.XLS.getValue())
				&& !fileName.toLowerCase().endsWith(ExcelTypeEnum.XLSX.getValue())) {
			throw new Exception("文件类型异常！");
		}
		InputStream input = multipartFile.getInputStream();
		XSSFWorkbook workbook = new XSSFWorkbook(input);
		XSSFSheet sheet = workbook.getSheetAt(0);
		List<Map<String, Object>> dataList = new ArrayList<>();
		if (sheet != null) {
			// 获取表头月份
			Row titleRow = sheet.getRow(0);
			// 958
			Cell monthCell = titleRow.getCell(6);
			String dateStr = monthCell == null ? "" : monthCell.toString();

			List<Date> dayByMonth = DateUtils.getDayByMonth(dateStr);
			if (ExcelEnums.CLZQ.getType().equals(dutyType)) {
				initDutyCarData(sheet, dataList, dayByMonth);
				dutyCarService.saveImportData(dataList);
			} else if (ExcelEnums.RYZB.getType().equals(dutyType)) {
				initDutyPersonData(sheet, dataList, dayByMonth);
				dutyPersonService.saveImportData(dataList);
			} else if (ExcelEnums.WXXFZB.getType().equals(dutyType)) {
				initDutyFireFightingData(sheet, dataList, dayByMonth);
				dutyFireFightingService.saveImportData(dataList);
			} else if (ExcelEnums.JJZB.getType().equals(dutyType)) {
				initDutyFirstAidData(sheet, dataList, dayByMonth);
				dutyFirstAidService.saveImportData(dataList);
			}
		}
    	
    }
	private void initDutyFirstAidData(XSSFSheet sheet, List<Map<String, Object>> dataList, List<Date> dayByMonth) {
		for (int i = 1; i < sheet.getPhysicalNumberOfRows(); i++) {
			DutyFirstAidDto dutyFirstAidDto = new DutyFirstAidDto();
			// row是一行数据，row.getCell(i),代表拿到这一行，第i列数据
			Row row = sheet.getRow(i);
			if (row == null) {
				continue;
			}
			Cell cell = row.getCell(2);
			if (cell == null) {
				continue;
			}
			cell = row.getCell(1);
			if (cell != null) {
				String[] split = cell.toString().split("@");
				dutyFirstAidDto.setTeamId(split[1]);
				dutyFirstAidDto.setTeamName(split[0]);
			}
			cell = row.getCell(2);
			if (cell != null) {
				String[] splitStr = cell.toString().split("@");
				dutyFirstAidDto.setUserName(splitStr[0]);
				dutyFirstAidDto.setUserId(splitStr[1]);
			}
			cell = row.getCell(3);
			if (cell != null) {
				String[] splitStr = cell.toString().split("@");
				dutyFirstAidDto.setPostTypeName(splitStr[0]);
				dutyFirstAidDto.setPostType(splitStr[1]);
			}
			cell = row.getCell(4);
			if (cell != null) {
				String[] splitStr = cell.toString().split("@");
				dutyFirstAidDto.setFirstAid(splitStr[0]);
				dutyFirstAidDto.setFirstAidId(splitStr[1]);
			}
			List<DutyPersonShiftDto> dutyShift = new ArrayList<>();
			for (int j = 0; j < dayByMonth.size(); j++) {
				cell = row.getCell(5 + j);
				String dutyType = cell == null ? "" : cell.toString();
				if (!StringUtils.isEmpty(dutyType)) {
					DutyPersonShiftDto dutyPersonShiftDto = new DutyPersonShiftDto();
					dutyPersonShiftDto.setDutyDate(dayByMonth.get(j));
					dutyPersonShiftDto.setShiftId(Long.valueOf(dutyType.split("@")[1]));
					dutyShift.add(dutyPersonShiftDto);
				}
			}
			dutyFirstAidDto.setDutyShift(dutyShift);
			Map<String, Object> dutyPersonDtoMap = Bean.BeantoMap(dutyFirstAidDto);
			dataList.add(dutyPersonDtoMap);
		}
		
	}

	private void excelImportSafeReport(MultipartFile multipartFile) throws Exception {

		String fileName = multipartFile.getOriginalFilename();
		if (fileName == null) {
			throw new Exception("文件不存在！");
		}
		if (!fileName.toLowerCase().endsWith(ExcelTypeEnum.XLS.getValue())
				&& !fileName.toLowerCase().endsWith(ExcelTypeEnum.XLSX.getValue())) {
			throw new Exception("文件类型异常！");
		}
		List<OrgUsrSafeReportExcelDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile,
				OrgUsrSafeReportExcelDto.class, 1);
		List<OrgUsrSafeReport> excelEntityList = new ArrayList<>();
		excelDtoList.forEach(fireExpertsDto -> {
			OrgUsrSafeReport reportExcel = new OrgUsrSafeReport();
			reportExcel = Bean.toPo(fireExpertsDto, reportExcel);
			reportExcel = Bean.toPo(getCurrentInfo(), reportExcel);
			if (reportExcel.getCompany() != null) {
				String[] compandyArr = reportExcel.getCompany().split("@");
				reportExcel.setCompany(compandyArr[0]);
				reportExcel.setCompanyId(Long.valueOf(compandyArr[1]));
			}
			excelEntityList.add(reportExcel);
		});
		orgUsrSafeReportService.saveBatch(excelEntityList);
	}

	private void initDutyCarData(XSSFSheet sheet, List<Map<String, Object>> dataList, List<Date> dayByMonth) {
		// 遍历行，i = 1，从第二行开始，第一行是表头跳过。
		for (int i = 1; i < sheet.getPhysicalNumberOfRows(); i++) {
			DutyCarDto dutyCarDto = new DutyCarDto();
			// row是一行数据，row.getCell(i),代表拿到这一行，第i列数据
			Row row = sheet.getRow(i);
			if (row == null) {
				continue;
			}
			Cell cell4 = row.getCell(4);
			if(cell4 ==null) {
				continue;
			}
			Cell cell = row.getCell(1);
			if (cell != null) {
				String[] split = cell.toString().split("@");
				dutyCarDto.setTeamName(split[0]);
				dutyCarDto.setTeamId(split[1]);
			}
			cell = row.getCell(2);
			if (cell != null) {
				String[] userName = cell.toString().split("@");
				dutyCarDto.setUserName(userName[0]);
				dutyCarDto.setUserId(userName[1]);

				cell = row.getCell(3);
				if (cell != null) {
					String[] postType = cell.toString().split("@");
					dutyCarDto.setPostTypeName(postType[0]);
					dutyCarDto.setPostType(postType[1]);
				}
				cell = row.getCell(4);
				if (cell != null) {
					String[] carName = cell.toString().split("@");
					dutyCarDto.setCarName(carName[0]);
					dutyCarDto.setCarId(carName[1]);
				}
				cell = row.getCell(5);
				if (cell != null) {
					String[] dutyArea = cell.toString().split("@");
					dutyCarDto.setDutyArea(dutyArea[0]);
					dutyCarDto.setDutyAreaId(dutyArea[1]);
				}
				List<DutyPersonShiftDto> dutyShift = dutyCarDto.getDutyShift();
				for (int j = 0; j < dayByMonth.size(); j++) {
					cell = row.getCell(6 + j);
					String dutyType = cell == null ? "" : cell.toString();
					if (!StringUtils.isEmpty(dutyType)) {
						DutyPersonShiftDto dutyPersonShiftDto = new DutyPersonShiftDto();
						dutyPersonShiftDto.setDutyDate(dayByMonth.get(j));
						dutyPersonShiftDto.setShiftId(Long.valueOf(dutyType.split("@")[1]));
						dutyShift.add(dutyPersonShiftDto);
					}
				}
				Map<String, Object> dutyCarDtoMap = Bean.BeantoMap(dutyCarDto);
				dataList.add(dutyCarDtoMap);
			}
		}
	}

	private void initDutyPersonData(XSSFSheet sheet, List<Map<String, Object>> dataList, List<Date> dayByMonth) {
		// 遍历行，i = 1，从第二行开始，第一行是表头跳过。
		for (int i = 1; i < sheet.getPhysicalNumberOfRows(); i++) {
			DutyPersonDto dutyPersonDto = new DutyPersonDto();
			// row是一行数据，row.getCell(i),代表拿到这一行，第i列数据
			Row row = sheet.getRow(i);
			if (row == null) {
				continue;
			}
			Cell	cell4 = row.getCell(4);
			if(cell4 ==null) {
				continue;
			}
			Cell cell = row.getCell(1);
			if (cell != null) {
				dutyPersonDto.setUserId(cell.toString());
				cell = row.getCell(2);
				if (cell != null) {
					dutyPersonDto.setUserName(cell.toString());
				}
				cell = row.getCell(3);
				if (cell != null) {
					String[] split = cell.toString().split("@");
					dutyPersonDto.setDeptName(split[0]);
					dutyPersonDto.setDeptId(split[1]);
				}
				cell = row.getCell(4);
				if (cell != null) {
					String[] split = cell.toString().split("@");
					dutyPersonDto.setPostTypeName(split[0]);
					dutyPersonDto.setPostType(split[1]);
				}
				// 需求958 添加值班区域 导入 by kongfm 2021-09-15
				cell = row.getCell(5);
				if (cell != null) {
					String[] dutyArea = cell.toString().split("@");
					dutyPersonDto.setDutyArea(dutyArea[0]);
					dutyPersonDto.setDutyAreaId(dutyArea[1]);
				}
				List<DutyPersonShiftDto> dutyShift = new ArrayList<>();
				for (int j = 0; j < dayByMonth.size(); j++) {
					cell = row.getCell(6 + j);
					String dutyType = cell == null ? "" : cell.toString();
					if (!StringUtils.isEmpty(dutyType)) {
						DutyPersonShiftDto dutyPersonShiftDto = new DutyPersonShiftDto();
						dutyPersonShiftDto.setDutyDate(dayByMonth.get(j));
						dutyPersonShiftDto.setShiftId(Long.valueOf(dutyType.split("@")[1]));
						dutyShift.add(dutyPersonShiftDto);
					}
				}
				dutyPersonDto.setDutyShift(dutyShift);
				Map<String, Object> dutyPersonDtoMap = Bean.BeantoMap(dutyPersonDto);
				dataList.add(dutyPersonDtoMap);
			}
		}
	}

	private void initDutyFireFightingData(XSSFSheet sheet, List<Map<String, Object>> dataList, List<Date> dayByMonth) {
		// 遍历行，i = 1，从第二行开始，第一行是表头跳过。
		for (int i = 1; i < sheet.getPhysicalNumberOfRows(); i++) {
			DutyFireFightingDto dutyFireFightingDto = new DutyFireFightingDto();
			// row是一行数据，row.getCell(i),代表拿到这一行，第i列数据
			Row row = sheet.getRow(i);
			if (row == null) {
				continue;
			}
			Cell cell = row.getCell(4);
			if (cell == null) {
				continue;
			}
			cell = row.getCell(1);
			if (cell != null) {
				String[] split = cell.toString().split("@");
				dutyFireFightingDto.setTeamId(split[1]);
				dutyFireFightingDto.setTeamName(split[0]);
			}
			cell = row.getCell(2);
			if (cell != null) {
				String[] splitStr = cell.toString().split("@");
				dutyFireFightingDto.setUserName(splitStr[0]);
				dutyFireFightingDto.setUserId(splitStr[1]);
			}
			cell = row.getCell(3);
			if (cell != null) {
				String[] splitStr = cell.toString().split("@");
				dutyFireFightingDto.setPostTypeName(splitStr[0]);
				dutyFireFightingDto.setPostType(splitStr[1]);
			}
			cell = row.getCell(4);
			if (cell != null) {
				String[] splitStr = cell.toString().split("@");
				dutyFireFightingDto.setFireFighting(splitStr[0]);
				dutyFireFightingDto.setFireFightingId(splitStr[1]);
			}
			List<DutyPersonShiftDto> dutyShift = new ArrayList<>();
			for (int j = 0; j < dayByMonth.size(); j++) {
				cell = row.getCell(5 + j);
				String dutyType = cell == null ? "" : cell.toString();
				if (!StringUtils.isEmpty(dutyType)) {
					DutyPersonShiftDto dutyPersonShiftDto = new DutyPersonShiftDto();
					dutyPersonShiftDto.setDutyDate(dayByMonth.get(j));
					dutyPersonShiftDto.setShiftId(Long.valueOf(dutyType.split("@")[1]));
					dutyShift.add(dutyPersonShiftDto);
				}
			}
			dutyFireFightingDto.setDutyShift(dutyShift);
			Map<String, Object> dutyPersonDtoMap = Bean.BeantoMap(dutyFireFightingDto);
			dataList.add(dutyPersonDtoMap);
		}
	}

	private void excelImportMaintenancePerson(MultipartFile multipartFile) throws Exception {
		List<MaintenancePersonExcleDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile,
				MaintenancePersonExcleDto.class, 1);
		List<DynamicFormColumn> columns = dynamicFormColumnService.list(
				new LambdaQueryWrapper<DynamicFormColumn>().eq(DynamicFormColumn::getGroupCode, MAINTENANCE_PERSON));
		List<MaintenanceCompany> maintenanceCompanyList = new ArrayList<MaintenanceCompany>();
		List<DynamicFormInstance> dynamicFormInstanceList = new ArrayList<DynamicFormInstance>();
		for (MaintenancePersonExcleDto maintenancePersonExcleDto : excelDtoList) {
			Long instanceId = sequence.nextId();
			// 先填充主表的属性
			MaintenanceCompany maintenanceCompany = new MaintenanceCompany();
			maintenanceCompany = Bean.toPo(maintenancePersonExcleDto, maintenanceCompany);
			maintenanceCompany = Bean.toPo(getCurrentInfo(), maintenanceCompany);
			maintenanceCompany.setType(PERSON);
			if (maintenanceCompany.getParentId() != null) {
				long getParentId = Long.valueOf(maintenancePersonExcleDto.getParentName().split("@")[1]);
				maintenanceCompany.setParentId(getParentId);
			}
			if (maintenanceCompanyService.checkPersonCodeExists(maintenancePersonExcleDto.getCode())) {
				maintenanceCompany.setBizCode(maintenancePersonExcleDto.getCode());
			} else {
				maintenanceCompany.setCode(null);
			}
			maintenanceCompany.setOrgCode(null);
			maintenanceCompany.setBizCode(sequence.nextId() + "");
			maintenanceCompany.setInstanceId(instanceId);
			maintenanceCompanyList.add(maintenanceCompany);
			maintenanceCompanyService.maintenancePersonExcleDtoToDynamicFormInstanceList(columns,
					maintenancePersonExcleDto, instanceId, dynamicFormInstanceList);
		}
		maintenanceCompanyService.saveMaintenanceCompanyBatch(maintenanceCompanyList, dynamicFormInstanceList);
	}

	private void excelImportKeySite(MultipartFile multipartFile) throws Exception {
		List<KeySiteExcleDto> excelDtoList = ExcelUtil.readFirstSheetExcel(multipartFile, KeySiteExcleDto.class, 1);
		keySiteService.saveExcel(excelDtoList);
	}

	public void dutyTemplateExport(HttpServletResponse response, String beginDate, String endDate, ExcelDto excelDto,
			String ids) {
		List<List<Object>> data = new ArrayList<>();
		if (ExcelEnums.CLZQ.getType().equals(excelDto.getType())) {
			data = initDutyCarTemplate(ids);
		} else if (ExcelEnums.RYZB.getType().equals(excelDto.getType())) {
			data = initDutyPersonTemplate(ids);
		} else if (ExcelEnums.WXXFZB.getType().equals(excelDto.getType())) {
			data = initDutyDutyFireFightingTemplate(ids);
		} else if (ExcelEnums.JJZB.getType().equals(excelDto.getType())) {
			data = initDutyDutyFirstAidTemplate(ids);
		}
		// 获取日期
		List<Map<String, Object>> rangeDate = dutyPersonShiftService.getBaseMapper().genRangeDate(beginDate, endDate);
		List<String> dayByMonth = new ArrayList<>();
		rangeDate.forEach(item -> dayByMonth.add((String) item.get("date")));
		exportDutyTemplate(response, excelDto.getClassUrl(), dayByMonth, excelDto, data, true,
				excelDto.getType(),true);
	}

	private List<List<Object>> initDutyDutyFirstAidTemplate(String ids) {
		List<List<Object>> data = new ArrayList<>();
		// 根据id列表获取单位下的微型消防站集合
		List<String> companyIdList = Lists.newArrayList();
		if (!ValidationUtil.isEmpty(ids)) {
			companyIdList = Lists.newArrayList(ids.split(","));
		}
		List<Map<String, Object>> personDetailList = dutyFirstAidService.getFirstAidExportData(companyIdList);

		if (!personDetailList.isEmpty()) {
			AtomicInteger row = new AtomicInteger(1);
			personDetailList.forEach(o -> {
				ArrayList<Object> list = new ArrayList<>();
				list.add(row.getAndIncrement());
				list.add(o.get("companyName"));
				list.add(o.get("userName"));
				list.add(o.get("postTypeName"));
				list.add(o.get("firstAidName"));
				data.add(list);
			});
		}
		return data;
	}

	private List<List<Object>> initDutyDutyFireFightingTemplate(String ids) {
		List<List<Object>> data = new ArrayList<>();
		// 根据id列表获取单位下的微型消防站集合
		List<String> companyIdList = Lists.newArrayList();
		if (!ValidationUtil.isEmpty(ids)) {
			companyIdList = Lists.newArrayList(ids.split(","));
		}
		List<Map<String, Object>> personDetailList = orgUsrServer.getPersonDetailByCompanyIds(companyIdList);

		if (!personDetailList.isEmpty()) {
			AtomicInteger row = new AtomicInteger(1);
			personDetailList.forEach(o -> {
				DutyFireFightingDto dto = (DutyFireFightingDto) Bean.mapToBean(o, DutyFireFightingDto.class);
				ArrayList<Object> list = new ArrayList<>();
				list.add(row.getAndIncrement());
				list.add(dto.getTeamName() + "@" + dto.getTeamId());
				list.add(dto.getUserName() + "@" + dto.getUserId());
				list.add(dto.getPostTypeName() + "@" + dto.getPostType());
				list.add(o.get("fireStation"));
				data.add(list);
			});
		}
		return data;
	}

	public void dutyInfoExport(HttpServletResponse response, String beginDate, String endDate, ExcelDto excelDto)
			throws ParseException {
		// 获取日期
		List<Map<String, Object>> rangeDate = dutyPersonShiftService.getBaseMapper().genRangeDate(beginDate, endDate);
		List<String> dayByMonth = new ArrayList<>();
		rangeDate.forEach(item -> dayByMonth.add((String) item.get("date")));
		List<List<Object>> data = new ArrayList<>();
		if (ExcelEnums.CLZQ.getType().equals(excelDto.getType())) {
			data = initDutyCarInfo(beginDate, endDate, dayByMonth);
		} else if (ExcelEnums.RYZB.getType().equals(excelDto.getType())) {
			data = initDutyPersonInfo(beginDate, endDate, dayByMonth);
		} else if (ExcelEnums.WXXFZB.getType().equals(excelDto.getType())) {
			data = initDutyDutyFireFighting(beginDate, endDate, dayByMonth);
		} else if (ExcelEnums.JJZB.getType().equals(excelDto.getType())) {
			data = initDutyDutyFirstAid(beginDate, endDate, dayByMonth);
		}

		exportDutyTemplate(response, excelDto.getClassUrl(), dayByMonth, excelDto, data, false, ExcelEnums.WXXFZB.getType(),false);
	}

	private List<List<Object>> initDutyDutyFirstAid(String beginDate, String endDate, List<String> dayByMonth) throws ParseException {

		List<DutyFirstAidDto> list = dutyFirstAidService.downloadList(beginDate, endDate);
		List<List<Object>> data = new ArrayList<>();
		// 组装导出数据
		if (!list.isEmpty()) {
			AtomicInteger row = new AtomicInteger(1);
			list.forEach(o -> {
				ArrayList<Object> detailList = new ArrayList<>();
				detailList.add(row.getAndIncrement());
				detailList.add(o.getTeamName());
				detailList.add(o.getUserName());
				detailList.add(o.getPostTypeName());
				detailList.add(o.getFirstAid());
				List<DutyPersonShiftDto> dutyShift = o.getDutyShift();
				initDutyShift(dayByMonth, dutyShift, detailList);
				data.add(detailList);
			});
		}
		return data;
	}

	private List<List<Object>> initDutyDutyFireFighting(String beginDate, String endDate,
			List<String> dayByMonth) throws ParseException {

		List<DutyFireFightingDto> list = dutyFireFightingService.downloadList(beginDate, endDate);
		List<List<Object>> data = new ArrayList<>();
		// 组装导出数据
		if (!list.isEmpty()) {
			AtomicInteger row = new AtomicInteger(1);
			list.forEach(o -> {
				ArrayList<Object> detailList = new ArrayList<>();
				detailList.add(row.getAndIncrement());
				detailList.add(o.getTeamName());
				detailList.add(o.getUserName());
				detailList.add(o.getPostTypeName());
				detailList.add(o.getFireFighting());
				List<DutyPersonShiftDto> dutyShift = o.getDutyShift();
				initDutyShift(dayByMonth, dutyShift, detailList);
				data.add(detailList);
			});
		}
		return data;
	}

	private List<List<Object>> initDutyCarTemplate(String teamIds) {
		List<List<Object>> data = new ArrayList<>();
		// 根据id列表获取队伍下的人
		List<String> teamIdList = Lists.newArrayList();
		if (!ValidationUtil.isEmpty(teamIds)) {
			teamIdList = Lists.newArrayList(teamIds.split(","));
		}
		List<FirefightersDto> firefightersDtoList = fireTeamService.getFighterByTeamId(teamIdList);

		if (!firefightersDtoList.isEmpty()) {
			AtomicInteger row = new AtomicInteger(1);
			firefightersDtoList.forEach(o -> {
				ArrayList<Object> list = new ArrayList<>();
				list.add(row.getAndIncrement());
				list.add(o.getFireTeamName() + "@" + o.getFireTeamId());
				list.add(o.getName() + "@" + o.getSequenceNbr());
				if(!ValidationUtil.isEmpty(o.getJobTitle())) {
					list.add(o.getJobTitle() + "@" + o.getJobTitleCode());
				}
				data.add(list);
			});
		}
		return data;
	}

	private List<List<Object>> initDutyPersonTemplate(String ids) {
		List<List<Object>> data = new ArrayList<>();
		// 根据id列表获取部门下的人
		List<Long> idList = Lists.newArrayList();
		if (!ValidationUtil.isEmpty(ids)) {
			String[] strings = ids.split(",");
			Long[] convert = (Long[]) ConvertUtils.convert(strings, Long.class);
			idList = Arrays.asList(convert);
		}
		try {
			List<CompanyPerson> companyPeople = orgUsrService.returnCompanyPerson(idList);
			if (!companyPeople.isEmpty()) {
				AtomicInteger row = new AtomicInteger(1);
				companyPeople.forEach(item -> {
					List<OrgUsrDto> persons = item.getPersons();
					if (persons != null && !persons.isEmpty()) {
						persons.forEach(o -> {
							ArrayList<Object> list = new ArrayList<>();
							list.add(row.getAndIncrement());
							list.add(o.getSequenceNbr().toString());
							list.add(o.getBizOrgName());
							list.add(item.getBizOrgName() + "@" + item.getSequenceNbr());
							data.add(list);
						});
					}
				});
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new RuntimeException("系统异常！");
		}
		return data;
	}

	private void exportDutyTemplate(HttpServletResponse response, String classUrl, List<String> dayByMonth,
			ExcelDto excelDto, List<? extends Object> data, Boolean flag, String typeFlag,boolean isTemplete) {
		try {
			// 获取排班类型
			String[] dutyNameList = getDutyNameList();
			Class<?> clz = Class.forName(classUrl);
			ExcelUtil.createDutyTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), data, clz,
					dayByMonth, dutyNameList, dataSourcesImpl, flag, typeFlag,isTemplete);

		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
	}

	private String[] getDutyNameList() {
		List<String> dutyShiftList = new ArrayList<>();
		List<DutyShiftDto> dutyShiftDtoList = dutyShiftService.queryForDutyShiftList(null, false);
		dutyShiftDtoList.forEach(item -> dutyShiftList.add(item.getName() + "@" + item.getSequenceNbr()));
		return dutyShiftList.toArray(new String[dutyShiftList.size()]);
	}

	private List<List<Object>> initDutyCarInfo(String beginDate, String endDate, List<String> dayByMonth)
			throws ParseException {
		// 查询已值班数据
		List<DutyCarDto> contentList = dutyCarService.downloadList(beginDate, endDate);
		List<List<Object>> data = new ArrayList<>();
		// 组装导出数据
		if (!contentList.isEmpty()) {
			AtomicInteger row = new AtomicInteger(1);
			contentList.forEach(o -> {
				ArrayList<Object> list = new ArrayList<>();
				list.add(row.getAndIncrement());
				list.add(o.getTeamName());
				list.add(o.getUserName());
				list.add(o.getPostTypeName());
				list.add(o.getCarName());
				list.add(o.getDutyArea());
				List<DutyPersonShiftDto> dutyShift = o.getDutyShift();
				initDutyShift(dayByMonth, dutyShift, list);

				data.add(list);
			});
		}
		return data;
	}

	private void initDutyShift(List<String> dayByMonth, List<DutyPersonShiftDto> dutyShift, ArrayList<Object> list) {
		HashMap<String, String> dutyShiftMap = new HashMap<>();
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		dutyShift.forEach(item -> dutyShiftMap.put(format.format(item.getDutyDate()), item.getShiftName()));

		for (int i = 0; i < dayByMonth.size(); i++) {
			if (dutyShiftMap.containsKey(dayByMonth.get(i))) {
				list.add(dutyShiftMap.get(dayByMonth.get(i)));
			} else {
				list.add(NOT_DUTY);
			}
		}
	}

	private List<List<Object>> initDutyPersonInfo(String beginDate, String endDate, List<String> dayByMonth)
			throws ParseException {
		// 查询已值班数据
		List<DutyPersonDto> contentList = iDutyPersonService.downloadList(beginDate, endDate);
		List<List<Object>> data = new ArrayList<>();
		// 组装导出数据
		if (!contentList.isEmpty()) {
			AtomicInteger row = new AtomicInteger(1);
			contentList.forEach(o -> {
				ArrayList<Object> list = new ArrayList<>();
				list.add(row.getAndIncrement());
				list.add(o.getUserId());
				list.add(o.getUserName());
				list.add(o.getDeptName());
				list.add(o.getPostTypeName());
				list.add(o.getDutyArea());
				List<DutyPersonShiftDto> dutyShift = o.getDutyShift();
				initDutyShift(dayByMonth, dutyShift, list);

				data.add(list);
			});
		}
		return data;
	}

	public void exportByParams(HttpServletResponse response, ExcelDto excelDto, String params) {
		switch (excelDto.getType()) {

//		case "WHP": 已废弃
//			List<FireChemicalDto> data = fireChemicalServiceImpl.queryForFireChemicalList(false);
//			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), data,
//					FireChemicalDto.class, dataSourcesImpl, false);
//			break;
		case "XFZJ":
			List<FireExpertsDto> fireExpertsDtoList = fireExpertsServiceImpl.queryForFireExpertsList(false,null,null);
			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), fireExpertsDtoList,
					FireExpertsDto.class, dataSourcesImpl, false);
			break;
//		case "SYXX": 已废弃
//			List<WaterResourceDto> waterResourceDtoList = waterResourceServiceImpl.exportToExcel(true);
//			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), waterResourceDtoList,
//					WaterResourceDto.class, dataSourcesImpl, false);
//			break;
//		case "HKQ": 已废弃
//			List<AircraftDto> aircraftDtoList = aircraftServiceImpl.queryAircraftDtoForList(false);
//			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), aircraftDtoList,
//					AircraftDto.class, dataSourcesImpl, false);
//			break;
		case "XFDW":
			List<FireTeamDto> fireTeamDtoList = fireTeamService.queryFireTeamForList(false,null);
			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), fireTeamDtoList,
					FireTeamDto.class, dataSourcesImpl, false);
			break;
		case "WXXFZ":
			List<FireStationDto> fireStationDtoList = fireStationService.queryForFireStationList(false,null,null,null);
			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), fireStationDtoList,
					FireStationDto.class, null, false);
			break;
		case "XFRY":
			List<FirefightersExcelDto> firefightersExcelDtoList = firefightersService.exportToExcel(false,null);
			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(),
					firefightersExcelDtoList, FirefightersExcelDto.class, null, false);
			break;
		case "WBRY":
			List<MaintenancePersonExcleDto> maintenancePersonExcelDtoList = maintenanceCompanyService
					.exportToMaintenancePersonExcel(null);
			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(),
					maintenancePersonExcelDtoList, MaintenancePersonExcleDto.class, null, false);
			break;
//		case "KEYSITE": 已废弃
//			List<KeySiteExcleDto> keySiteDtoList = keySiteService.exportToExcel();
//			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), keySiteDtoList,
//					KeySiteExcleDto.class, null, false);
//			break;
		case "JCDWRY":
			// 机场单位人员参数传递为 parentId = xxxxxxx
			String parentIdStr = params.split("=")[1];
			Long parentId = -1l;
			try {
				parentId = Long.parseLong(parentIdStr);
			} catch (NumberFormatException e) {
				throw new BadRequest("导出机场单位时未传递正确parentId");
			}
			List<OrgUsrExcelDto> orgUsrList = orgUsrService.exportPersonToExcelByParentId(parentId);
			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), orgUsrList,
					OrgUsrExcelDto.class, null, false);
			break;
//		case "LDDW": 已废弃
//			List<LinkageUnitDto> LinkageUnitDtoList = linkageUnitServiceImpl.exportToExcel();
//
//			ExcelUtil.createTemplate(response, excelDto.getFileName(), excelDto.getSheetName(), LinkageUnitDtoList,
//					LinkageUnitDto.class, null, false);
//			break;
		default:
			break;
		}
	}

	@Autowired
	private RedisUtils redisUtils;

	public BaseEntity getCurrentInfo() {
		BaseEntity userModel = new BaseEntity();
		FeignClientResult<AgencyUserModel> agencyUserModel = Privilege.agencyUserClient.getme();
		AgencyUserModel userModel1 = agencyUserModel.getResult();
		String keyString = userModel1.getUserId();
		String token = RequestContext.getToken();
		ReginParams params = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(keyString, token)).toString(),
				ReginParams.class);
		userModel.setRecUserId(params.getUserModel().getUserId());
		userModel.setRecUserName(params.getUserModel().getRealName());
		userModel.setRecDate(new Date());
		return userModel;
	}
	public ReginParams getCurrentAllInfo() {
		BaseEntity userModel = new BaseEntity();
		FeignClientResult<AgencyUserModel> agencyUserModel = Privilege.agencyUserClient.getme();
		AgencyUserModel userModel1 = agencyUserModel.getResult();
		String keyString = userModel1.getUserId();
		String token = RequestContext.getToken();
		return JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(keyString, token)).toString(),
				ReginParams.class);
	}

	public boolean getFlag(Map par){

		ReginParams  reginParams=	getCurrentAllInfo();
		boolean authFalg= false;
		if(reginParams!=null&&reginParams.getPersonIdentity()!=null&&reginParams.getPersonIdentity().getBizOrgCode()!=null) {
			authFalg=true;
		}
		if(authFalg&&par.containsKey("bizOrgCode")&& par.get("bizOrgCode")!=null&&!(par.get("bizOrgCode").toString()).equals("")){
          return true;
		}
		return false;
	}


}
